/*
 * Created on 2004/11/26
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.nodeview;

import java.net.InetAddress;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import netjfwatcher.preference.Preference;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * F؃m[hr[j[t[ZbgANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class AuthNodeViewMenu extends Action {
    private static Logger logger;

    public ActionForward execute(
        ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception {
        logger = Logger.getLogger(this.getClass().getName());

        String engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (engineAddress == null) {
            engineAddress = "localhost";
            logger.warning("Not engine address : " + engineAddress);
        }

        String servernamework1 =
            InetAddress.getLocalHost().toString().replace('.', '_');
        String servernamework2 = servernamework1.replace('/', '_');
        String servername = servernamework2.replace('-', '_');

        String nodeIPAddress = request.getParameter(Preference.IPADDRESS);
        String convIPAddress = nodeIPAddress.replace('.', '_');
        HttpSession session = request.getSession();

        String authMode = (String) session.getAttribute(Preference.AUTH_MODE);

        if (authMode == null) {
            // session.setAttribute("authmode", "noauth");
            session.setAttribute(
                Preference.AUTH_MODE, Preference.AUTH_MODE_AUTH);
        }

        request.setAttribute(
            Preference.AUTH_MODE, session.getAttribute(Preference.AUTH_MODE));
        request.setAttribute(Preference.NODE_IPADDRESS, nodeIPAddress);
        request.setAttribute(Preference.CONV_IPADDRESS, convIPAddress);
        request.setAttribute(Preference.SERVER_NAME, servername);
        request.setAttribute(Preference.ENGINE_ADDRESS, engineAddress);

        return mapping.findForward(Preference.SUCCESS);
    }
}
