/*
 * Created on 2003/07/17
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.noderegister;

import java.io.IOException;
import java.net.InetAddress;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.nodemanager.listoperation.AbstractNodeAction;
import netjfwatcher.noderegister.model.NodeRegistException;
import netjfwatcher.noderegister.model.NodeRegisterModel;
import netjfwatcher.preference.Preference;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * m[hĎݒ肷ANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeRegisterAction extends AbstractNodeAction {
    private static Logger logger = null;

    public ActionForward execute(
        ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception {
        logger = Logger.getLogger(this.getClass().getName());

        String engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (engineAddress == null) {
            logger.warning("Not Engine Addreess : " + engineAddress);
        }

        String cancel = request.getParameter("cancel");

        if ((cancel != null) && cancel.equals("Cancel")) {
            String servernamework1 =
                InetAddress.getLocalHost().toString().replace('.', '_');
            String servernamework2 = servernamework1.replace('/', '_');
            String servername = servernamework2.replace('-', '_');

            request.setAttribute(Preference.SERVER_NAME, servername);
            request.setAttribute(Preference.ENGINE_ADDRESS, "all");

            return mapping.findForward(Preference.SUCCESS);
        }

        String servernamework1 =
            InetAddress.getLocalHost().toString().replace('.', '_');
        String servernamework2 = servernamework1.replace('/', '_');
        String servername = servernamework2.replace('-', '_');

        request.setAttribute(Preference.SERVER_NAME, servername);

        /* m[ho^f𐶐Am[ho^s */
        NodeRegisterModel nodeRegisterModel = new NodeRegisterModel();

        try {
            NodeInformation nodeInfo = createNodeInfo(request);
            nodeRegisterModel.registerNode(nodeInfo);
        } catch (NodeRegistException e1) {
            /* m[ho^s */
            logger.warning(e1.getMessage());
            request.setAttribute(Preference.ERROR_MESSAGE, e1.getMessage());

            return mapping.findForward(Preference.ERROR1);
        } catch (EngineConnectException e1) {
            /* m[ho^s(GWڑُ) */
            logger.warning(e1.getMessage());
            request.setAttribute(Preference.ERROR_MESSAGE, e1.getMessage());

            return mapping.findForward(Preference.ERROR1);
        } catch (IOException e1) {
            /* m[ho^s(GWڑُ) */
            logger.warning(e1.getMessage());
            request.setAttribute(Preference.ERROR_MESSAGE, e1.getMessage());

            return mapping.findForward(Preference.ERROR1);
        }

        // m[ho^ɑSẴGWAhX̏\
        request.setAttribute(Preference.ENGINE_ADDRESS, "all");

        return mapping.findForward(Preference.SUCCESS);
    }
}
