/*
 * Created on 2004/05/21
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.nodemap;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.library.ClientFlashInfo;
import netjfwatcher.preference.Preference;
import netjfwatcher.resourceconfig.EngineResourceConfig;
import netjfwatcher.resourceconfig.EngineResourceInfo;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * m[hMap\ANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NetMapDrawPreAction extends Action {
    /** m[hMap\ */
    public static final int MAP_WIDTH = 1900;

    /** m[hMap\ */
    public static final int MAP_HEIGHT = 1200;
    private static Logger logger;

    public ActionForward execute(
        ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception {
        logger = Logger.getLogger(this.getClass().getName());

        String engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (engineAddress == null) {
            ArrayList engineList =
                EngineResourceConfig.getInstance().getEngineInfo()
                                    .getEngineInfoList();
            engineAddress =
                ((EngineResourceInfo) engineList.get(0)).getEngineIPaddress();
        }

        String mapSize = request.getParameter(Preference.MAP_SIZE);
        String mapWidth = "";
        String mapHeight = "";
        int width = MAP_WIDTH;
        int height = MAP_HEIGHT;

        if ((mapSize == null) || mapSize.equals("")) {
            mapSize = "100";
        }

        float scall = Float.parseFloat(mapSize) / 100;

        mapWidth = Float.toString(scall * width);
        mapHeight = Float.toString(scall * height);

        InetAddress localAddress = InetAddress.getLocalHost();
        String servername = localAddress.getHostAddress();

        /*
         * Flash XMLSocketłlocalhostւ̐ڑłIPAhXł͂ȂlocalhostɂȂ
         * ڑłȂ
         */
        if (request.getRemoteAddr().equals("127.0.0.1")) {
            request.setAttribute(Preference.SERVER_NAME, "localhost");
        } else {
            request.setAttribute(Preference.SERVER_NAME, servername);
        }

        ClientFlashInfo clientInfo = new ClientFlashInfo();
        request = clientInfo.getClientFlashInfo(engineAddress, request);
        request.setAttribute(
            Preference.REFRESH_TIMER, Preference.REFRESH_TIMER_HIDDEN);
        request.setAttribute(Preference.MAP_WIDTH, mapWidth);
        request.setAttribute(Preference.MAP_HEIGHT, mapHeight);
        request.setAttribute(Preference.MAP_SCALL, mapSize);
        request.setAttribute(
            Preference.MAP_AUTH_MODE, Preference.AUTH_MODE_AUTH);

        String servernamework1 =
            InetAddress.getLocalHost().toString().replace('.', '_');
        String servernamework2 = servernamework1.replace('/', '_');
        String frameNameforServername = servernamework2.replace('-', '_');

        request.setAttribute(Preference.ENGINE_ADDRESS, engineAddress);
        request.setAttribute(
            Preference.FRAME_NAME_AT_SERVER_NAME, frameNameforServername);

        return mapping.findForward(Preference.SUCCESS);
    }
}
