/*
 * Created on 2003/08/14
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.nodemanager.start;

import java.io.IOException;
import java.net.InetAddress;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.preference.Preference;
import netjfwatcher.test.model.TestNetWatch;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * ʃm[h}l[Wt[NJSPNANVNXłB
 * ȉ̃t[NJSPN܂B
 * Em[h}l[W j[
 * EXML Socketڑt[/m[hXgt[/A[t[
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeManagerFrame extends Action {
    private static Logger logger = null;

    public ActionForward execute(
        ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response)
        throws EngineConnectException, IOException {
        logger = Logger.getLogger(this.getClass().getName());

        String engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (engineAddress == null) {
            engineAddress = "all";
        }

        // GWڑeXg
        try {
            TestNetWatch test = new TestNetWatch();
            test.testEngine(engineAddress);
        } catch (EngineConnectException e) {
            return mapping.findForward(Preference.ENGINE_CHECK);
        } catch (IOException e) {
            return mapping.findForward(Preference.ENGINE_CHECK);
        }

        String servername = request.getParameter(Preference.SERVER_NAME);

        if (servername == null) {
            String servernamework1 =
                InetAddress.getLocalHost().toString().replace('.', '_');
            String servernamework2 = servernamework1.replace('/', '_');
            servername = servernamework2.replace('-', '_');
        }

        request.setAttribute(Preference.SERVER_NAME, servername);
        request.setAttribute(Preference.ENGINE_ADDRESS, engineAddress);

        return mapping.findForward(Preference.SUCCESS);
    }
}
