/*
 * Created on 2003/08/11
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.nodemanager.start;

import java.net.InetAddress;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import netjfwatcher.preference.Preference;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * Ǘ҃m[h}l[WWindowI[vAWindowI[vɃt[\ANV
 * NANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class AuthNodeManagerStart extends Action {
    private static Logger logger = null;

    public ActionForward execute(
        ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception {
        logger = Logger.getLogger(this.getClass().getName());

        String engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (engineAddress == null) {
            logger.warning("Not Engine Addreess : " + engineAddress);
        }

        String servernamework1 =
            InetAddress.getLocalHost().toString().replace('.', '_');
        String servernamework2 = servernamework1.replace('/', '_');
        String servername = servernamework2.replace('-', '_');

        request.setAttribute(Preference.SERVER_NAME, servername);
        request.setAttribute(Preference.ENGINE_ADDRESS, engineAddress);

        HttpSession session = request.getSession();
        session.setAttribute(Preference.AUTH_MODE, Preference.AUTH_MODE_AUTH);

        return mapping.findForward(Preference.SUCCESS);
    }
}
