/*
 * Created on 2003/08/14
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.nodemanager.listoperation.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.engine.command.control.CommandMappingTableResource;
import netjfwatcher.engine.socket.ConnectionNodeControl;
import netjfwatcher.engine.socket.ConnectionNodeInformation;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.nodemanager.listoperation.AllNodeEditViewAction;
import netjfwatcher.resourceconfig.EngineResourceConfig;
import netjfwatcher.resourceconfig.EngineResourceInfo;


/**
 * m[hĎ̕ҏWGWɒʒm郁\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeEditModel {
    /* MO */
    private static Logger logger = null;

    /**
     * m[hĎ̕ҏWGWɒʒmNXCX^X
     * ܂B
     */
    public NodeEditModel() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * m[hĎ̕ҏWGWɒʒm܂B
     *
     * @param nodeInformation m[hĎ
     * @throws EngineConnectException GWƂ̐ڑňُoꍇ
     * @throws IOException GWƂ̐ڑňُoꍇ
     */
    public void editNodeInfo(NodeInformation nodeInformation)
        throws EngineConnectException, IOException {
        // m[hĎXV
        // noderegister.update();
        // GWɃm[hXVʒm
        ConnectionNodeControl threadstop =
            new ConnectionNodeControl(nodeInformation.getEngineAddress());
        threadstop.requestThread(
            nodeInformation.getIpaddress(),
            CommandMappingTableResource.THREAD_RESTART_COMMAND_ID,
            nodeInformation);
    }

    /**
     * m[hĎ̕ҏWGW֒ʒm܂B
     *
     * @param nodeInfo m[hĎ
     * @throws EngineConnectException GWƂ̐ڑňُoꍇ
     * @throws IOException GWƂ̐ڑňُoꍇ
     */
    public void editAllNodeInfo(final NodeInformation nodeInfo)
        throws EngineConnectException, IOException {
        if (nodeInfo.getEngineAddress().equals("all")) {
            ArrayList engineList =
                EngineResourceConfig.getInstance().getEngineInfo()
                                    .getEngineInfoList();

            for (int i = 0; i < engineList.size(); i++) {
                String testEngineAddress =
                    ((EngineResourceInfo) engineList.get(i)).getEngineIPaddress();
                logger.info("Check engine connect : " + testEngineAddress);

                ArrayList nodeInfoList = null;

                try {
                    ConnectionNodeInformation connectionNodeInfoList =
                        new ConnectionNodeInformation(testEngineAddress);
                    nodeInfoList =
                        connectionNodeInfoList.getNodeInformationList(
                            null, null);
                } catch (EngineConnectException e) {
                    logger.info("abort connect engine : " + testEngineAddress);
                    logger.info(e.getMessage());

                    continue;
                } catch (IOException e) {
                    logger.info("abort connect engine : " + testEngineAddress);
                    logger.info(e.getMessage());

                    continue;
                }

                if (nodeInfoList == null) {
                    logger.info(
                        "abort get Node Inof List. engine : "
                        + testEngineAddress);

                    continue;
                }

                for (int j = 0; j < nodeInfoList.size(); j++) {
                    /* GW猻݂̃m[hĎ擾 */
                    NodeInformation editWorkNodeInfo =
                        (NodeInformation) nodeInfoList.get(j);

                    /* GWɑMm[hĎ񐶐 */
                    NodeInformation editNodeInfo =
                        createNodeInfo(nodeInfo, editWorkNodeInfo);

                    // nodeinfo.update();
                    logger.info(
                        "Connect engineAddress : "
                        + nodeInfo.getEngineAddress());

                    try {
                        ConnectionNodeControl threadstop =
                            new ConnectionNodeControl(testEngineAddress);
                        String ipaddress = editNodeInfo.getIpaddress();
                        threadstop.requestThread(
                            ipaddress,
                            CommandMappingTableResource.THREAD_RESTART_COMMAND_ID,
                            editNodeInfo);
                    } catch (EngineConnectException e) {
                        logger.info("abort engine : " + testEngineAddress);
                        logger.info(e.getMessage());
                    } catch (IOException e) {
                        logger.info("abort engine : " + testEngineAddress);
                        logger.info(e.getMessage());
                    }
                }
            }
        } else {
            logger.warning("Illegal address : " + nodeInfo.getEngineAddress());
        }
    }

    /*
     * GW擾m[hĎҏWĕԂ܂B
     *
     * @param nodeInfo@ҏWݒ肳ꂽm[hĎ
     * @param workEditNodeInfo GW擾m[hĎ
     * @return GWɑMm[hĎ
     */
    private NodeInformation createNodeInfo(
        final NodeInformation nodeInfo, NodeInformation workEditNodeInfo) {
        if (
            !nodeInfo.getGroup().equals("")
                && !nodeInfo.getGroup().equals(AllNodeEditViewAction.WILD_CARD)) {
            workEditNodeInfo.setGroup(nodeInfo.getGroup());
        }

        if (
            !nodeInfo.getNodeKind().equals("")
                && !nodeInfo.getNodeKind().equals(
                    AllNodeEditViewAction.WILD_CARD)) {
            workEditNodeInfo.setNodeKind(nodeInfo.getNodeKind());
        }

        if (
            !nodeInfo.getPingPeriod().equals("")
                && !nodeInfo.getPingPeriod().equals(
                    AllNodeEditViewAction.WILD_CARD)) {
            workEditNodeInfo.setPingPeriod(nodeInfo.getPingPeriod());
        }

        if (
            !nodeInfo.getPingThreshold().equals("")
                && !nodeInfo.getPingThreshold().equals(
                    AllNodeEditViewAction.WILD_CARD)) {
            workEditNodeInfo.setPingThreshold(nodeInfo.getPingThreshold());
        }

        if (
            !nodeInfo.getSnmpLevel().equals("")
                && !nodeInfo.getSnmpLevel().equals(
                    AllNodeEditViewAction.WILD_CARD)) {
            workEditNodeInfo.setSnmpLevel(nodeInfo.getSnmpLevel());
        }

        if (
            !nodeInfo.getSnmpPeriod().equals("")
                && !nodeInfo.getSnmpPeriod().equals(
                    AllNodeEditViewAction.WILD_CARD)) {
            workEditNodeInfo.setSnmpPeriod(nodeInfo.getSnmpPeriod());
        }

        if (
            !nodeInfo.getRoCommunity().equals("")
                && !nodeInfo.getRoCommunity().equals(
                    AllNodeEditViewAction.WILD_CARD)) {
            workEditNodeInfo.setRoCommunity(nodeInfo.getRoCommunity());
        }

        if (
            (nodeInfo.getHttpPeriod() != null)
                && !nodeInfo.getHttpPeriod().equals("")
                && !nodeInfo.getHttpPeriod().equals(
                    AllNodeEditViewAction.WILD_CARD)) {
            workEditNodeInfo.setHttpPeriod(nodeInfo.getHttpPeriod());
        }

        if (
            (nodeInfo.getHttpUrl() != null)
                && !nodeInfo.getHttpUrl().equals("")
                && !nodeInfo.getHttpUrl().equals(
                    AllNodeEditViewAction.WILD_CARD)) {
            workEditNodeInfo.setHttpPort(nodeInfo.getHttpUrl());
        }

        if (
            (nodeInfo.getHttpTimeout() != null)
                && !nodeInfo.getHttpTimeout().equals("")
                && !nodeInfo.getHttpTimeout().equals(
                    AllNodeEditViewAction.WILD_CARD)) {
            workEditNodeInfo.setHttpTimeout(nodeInfo.getHttpTimeout());
        }

        if (
            (nodeInfo.getPopPeriod() != null)
                && !nodeInfo.getPopPeriod().equals("")
                && !nodeInfo.getPopPeriod().equals(
                    AllNodeEditViewAction.WILD_CARD)) {
            workEditNodeInfo.setPopPeriod(nodeInfo.getPopPeriod());
        }

        if (
            (nodeInfo.getPopUser() != null)
                && !nodeInfo.getPopUser().equals("")
                && !nodeInfo.getPopUser().equals(
                    AllNodeEditViewAction.WILD_CARD)) {
            workEditNodeInfo.setPopUser(nodeInfo.getPopUser());
        }

        if (
            (nodeInfo.getPopPassword() != null)
                && !nodeInfo.getPopPassword().equals("")
                && !nodeInfo.getPopPassword().equals(
                    AllNodeEditViewAction.WILD_CARD)) {
            workEditNodeInfo.setPopPassword(nodeInfo.getPopPassword());
        }

        if (
            (nodeInfo.getPopPort() != null)
                && !nodeInfo.getPopPort().equals("")
                && !nodeInfo.getPopPort().equals(
                    AllNodeEditViewAction.WILD_CARD)) {
            workEditNodeInfo.setPopPort(nodeInfo.getPopPort());
        }

        if (
            (nodeInfo.getPopTimeout() != null)
                && !nodeInfo.getPopTimeout().equals("")
                && !nodeInfo.getPopTimeout().equals(
                    AllNodeEditViewAction.WILD_CARD)) {
            workEditNodeInfo.setPopTimeout(nodeInfo.getPopTimeout());
        }

        if (
            (nodeInfo.getSmtpPeriod() != null)
                && !nodeInfo.getSmtpPeriod().equals("")
                && !nodeInfo.getSmtpPeriod().equals(
                    AllNodeEditViewAction.WILD_CARD)) {
            workEditNodeInfo.setSmtpPeriod(nodeInfo.getSmtpPeriod());
        }

        if (
            (nodeInfo.getSmtpPort() != null)
                && !nodeInfo.getSmtpPort().equals("")
                && !nodeInfo.getSmtpPort().equals(
                    AllNodeEditViewAction.WILD_CARD)) {
            workEditNodeInfo.setSmtpPort(nodeInfo.getSmtpPort());
        }

        if (
            (nodeInfo.getSmtpTimeout() != null)
                && !nodeInfo.getSmtpTimeout().equals("")
                && !nodeInfo.getSmtpTimeout().equals(
                    AllNodeEditViewAction.WILD_CARD)) {
            workEditNodeInfo.setSmtpTimeout(nodeInfo.getSmtpTimeout());
        }

        if (
            (nodeInfo.getSmtpSendAddress() != null)
                && !nodeInfo.getSmtpSendAddress().equals("")
                && !nodeInfo.getSmtpSendAddress().equals(
                    AllNodeEditViewAction.WILD_CARD)) {
            workEditNodeInfo.setSmtpSendAddress(nodeInfo.getSmtpSendAddress());
        }

        if (
            (nodeInfo.getSmtpCheckHost() != null)
                && !nodeInfo.getSmtpCheckHost().equals("")
                && !nodeInfo.getSmtpCheckHost().equals(
                    AllNodeEditViewAction.WILD_CARD)) {
            workEditNodeInfo.setSmtpCheckHost(nodeInfo.getSmtpCheckHost());
        }

        if (
            (nodeInfo.getSmtpCheckUser() != null)
                && !nodeInfo.getSmtpCheckUser().equals("")
                && !nodeInfo.getSmtpCheckUser().equals(
                    AllNodeEditViewAction.WILD_CARD)) {
            workEditNodeInfo.setSmtpCheckUser(nodeInfo.getSmtpCheckUser());
        }

        if (
            (nodeInfo.getSmtpCheckPassword() != null)
                && !nodeInfo.getSmtpCheckPassword().equals("")
                && !nodeInfo.getSmtpCheckPassword().equals(
                    AllNodeEditViewAction.WILD_CARD)) {
            workEditNodeInfo.setSmtpCheckPassword(
                nodeInfo.getSmtpCheckPassword());
        }

        if (
            (nodeInfo.getSmtpCheckPort() != null)
                && !nodeInfo.getSmtpCheckPort().equals("")
                && !nodeInfo.getSmtpCheckPort().equals(
                    AllNodeEditViewAction.WILD_CARD)) {
            workEditNodeInfo.setSmtpCheckPort(nodeInfo.getSmtpCheckPort());
        }

        if (
            (nodeInfo.getSmtpCheckTimeout() != null)
                && !nodeInfo.getSmtpCheckTimeout().equals("")
                && !nodeInfo.getSmtpCheckTimeout().equals(
                    AllNodeEditViewAction.WILD_CARD)) {
            workEditNodeInfo.setSmtpCheckTimeout(
                nodeInfo.getSmtpCheckTimeout());
        }

        return workEditNodeInfo;
    }

    /**
     * GWm[hĎ擾܂B
     *
     * @param engineAddress GWAhX
     * @param ipaddress m[hIPAhX
     * @return nodeInfo m[hĎ
     * @throws EngineConnectException GWƂ̐ڑňُoꍇ
     * @throws IOException GWƂ̐ڑňُoꍇ
     */
    public NodeInformation getEditNodeInfo(
        String engineAddress, String ipaddress)
        throws EngineConnectException, IOException {
        // logger.info("Engine address : " + engineAddress);
        // logger.info("Target address : " + ipaddress);
        NodeInformation nodeInfo = null;
        ConnectionNodeInformation connection =
            new ConnectionNodeInformation(engineAddress);

        nodeInfo = connection.getNodeInformation(ipaddress);

        return nodeInfo;
    }
}
