/*
 * Created on 2003/08/14
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.nodemanager.listoperation;

import java.net.InetAddress;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.nodemanager.listoperation.model.NodeEditModel;
import netjfwatcher.preference.Preference;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * m[hĎҏWANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeEditSubmitAction extends AbstractNodeAction {
    private static Logger logger;

    public ActionForward execute(
        ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception {
        logger = Logger.getLogger(this.getClass().getName());

        // LZ{^
        String mode = request.getParameter("cancel");
        String engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (engineAddress == null) {
            logger.warning("Not Engine Address");
            engineAddress = "localhost";
        }

        if ((mode != null) && mode.equals("Cancel")) {
            // ҏWLZ
            logger.info("Node Edit cancel");
        } else {
            NodeInformation nodeInfo = createNodeInfo(request);
            NodeEditModel nodeedit = new NodeEditModel();
            nodeedit.editNodeInfo(nodeInfo);

            logger.info("Node edit IP=" + nodeInfo.getIpaddress());
        }

        String servernamework1 =
            InetAddress.getLocalHost().toString().replace('.', '_');
        String servernamework2 = servernamework1.replace('/', '_');
        String servername = servernamework2.replace('-', '_');
        request.setAttribute(Preference.SERVER_NAME, servername);
        request.setAttribute(Preference.ENGINE_ADDRESS, "all");

        return mapping.findForward(Preference.SUCCESS);
    }
}
