/*
 * Created on 2004/06/27
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.nodemanager.listoperation;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.nodemanager.list.model.NodeListViewModel;
import netjfwatcher.preference.Preference;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * So^m[h̃m[hĎvpeBXgƂăNCAgɕԂANV
 * NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class AllNodePropertyListViewAction extends Action {
    private static Logger logger = null;

    public ActionForward execute(
        ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response)
        throws EngineConnectException, UnknownHostException, IOException {
        logger = Logger.getLogger(this.getClass().getName());

        String engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (engineAddress == null) {
            logger.warning("Not Engine Address");
            engineAddress = "localhost";
        }

        /*
         * m[hĎ񃊃Xg擾
         */
        NodeListViewModel noderegister = new NodeListViewModel();
        ArrayList nodeList = noderegister.getList(engineAddress, null, null);

        for (int i = 0; i < nodeList.size(); ++i) {
            NodeInformation nodeInfo = (NodeInformation) nodeList.get(i);

            if (nodeInfo.getSnmpLevel().equals(Preference.SNMP_LEVEL0)) {
                nodeInfo.setSnmpLevel(Preference.NO_SNMP);
            } else if (nodeInfo.getSnmpLevel().equals(Preference.SNMP_LEVEL1)) {
                nodeInfo.setSnmpLevel(Preference.SNMP_CONFIG);
            } else if (nodeInfo.getSnmpLevel().equals(Preference.SNMP_LEVEL2)) {
                nodeInfo.setSnmpLevel(Preference.SNMP_IFOCTETS);
            } else if (nodeInfo.getSnmpLevel().equals(Preference.SNMP_LEVEL3)) {
                nodeInfo.setSnmpLevel(Preference.SNMP_LALOAD);
            } else if (nodeInfo.getSnmpLevel().equals(Preference.SNMP_LEVEL4)) {
                nodeInfo.setSnmpLevel(Preference.SNMP_DISK);
            }
        }

        String servernamework1 =
            InetAddress.getLocalHost().toString().replace('.', '_');
        String servernamework2 = servernamework1.replace('/', '_');
        String servername = servernamework2.replace('-', '_');

        request.setAttribute(Preference.SERVER_NAME, servername);
        request.setAttribute(Preference.ENGINE_ADDRESS, "all");
        request.setAttribute(Preference.NODE_CONFIG_LIST, nodeList);

        return mapping.findForward(Preference.SUCCESS);
    }
}
