/*
 * Created on 2004/05/13
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.nodemanager.listoperation;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.nodemanager.listoperation.model.NodeEditModel;
import netjfwatcher.preference.Preference;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.NodeInformation;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * m[ho^Ăm[h̊ĎvpeBSm[hɑ΂ĕҏW
 * ANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class AllNodeEditAction extends AbstractNodeAction {
    /* MO */
    private static Logger logger = null;

    public ActionForward execute(
        ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response)
        throws EngineConnectException, UnknownHostException, IOException {
        logger = Logger.getLogger(this.getClass().getName());

        String engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (engineAddress == null) {
            engineAddress = "all";
        }


        // LZ{^
        String mode = request.getParameter("cancel");

        if ((mode != null) && mode.equals("Cancel")) {
            // ҏWLZ
            logger.info("All Node Edit cancel");
        } else {
            NodeInformation nodeInfo = createNodeInfo(request);
            nodeInfo.setEngineAddress(engineAddress);

            NodeEditModel nodeedit = new NodeEditModel();
            nodeedit.editAllNodeInfo(nodeInfo);
        }

        String servernamework1 =
            InetAddress.getLocalHost().toString().replace('.', '_');
        String servernamework2 = servernamework1.replace('/', '_');
        String servername = servernamework2.replace('-', '_');

        request.setAttribute(Preference.SERVER_NAME, servername);
        request.setAttribute(Preference.ENGINE_ADDRESS, "all");

        return mapping.findForward(Preference.SUCCESS);
    }
}
