/*
 * Created on 2004/05/13
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.nodemanager.listoperation;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.engine.socket.info.NodeInformation;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * NCAg̃m[hĎp[^𒊏oAm[hĎ𐶐
 * \bh钊ۃANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public abstract class AbstractNodeAction extends Action {

    public abstract ActionForward execute(
        ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception;

    /**
     * NCAg̃m[hĎp[^𒊏oAm[hĎCX^X
     * 𐶐܂B
     *
     * @param request HttpServletRequest
     * @return nodeInformation NodeInformation
     */
    public NodeInformation createNodeInfo(HttpServletRequest request) {
        String engineAddress = request.getParameter("engineAddress");
        String nodeName = request.getParameter("nodename");
        String ipAddress = request.getParameter("ipaddress");
        String group = request.getParameter("group");
        String nodeKind = request.getParameter("nodeKind");

        /* PingĎ */
        String pingPeriod = request.getParameter("pingPeriod");
        String pingThreshold = request.getParameter("pingThreshold");

        /* SNMPĎ */
        String snmpVersion = request.getParameter("snmpVersion");
        String snmpPeriod = request.getParameter("snmpPeriod");
        String snmpLevel = request.getParameter("snmpLevel");
        String roCommunity = request.getParameter("roCommunity");
        String rwCommunity = request.getParameter("rwCommunity");

        /* HTTPĎ */
        String httpPeriod = request.getParameter("httpPeriod");
        String httpUrl = request.getParameter("httpUrl");
        String httpTimeout = request.getParameter("httpTimeout");

        /* Pop3Ď */
        String popPeriod = request.getParameter("popPeriod");
        String popUser = request.getParameter("popUser");
        String popPassword = request.getParameter("popPassword");
        String popPort = request.getParameter("popPort");
        String popTimeout = request.getParameter("popTimeout");

        /* SMTPĎ */
        String smtpPeriod = request.getParameter("smtpPeriod");
        String smtpPort = request.getParameter("smtpPort");
        String smtpTimeout = request.getParameter("smtpTimeout");
        String smtpSendAddress = request.getParameter("smtpSendAddress");
        String smtpCheckHost = request.getParameter("smtpCheckHost");
        String smtpCheckUser = request.getParameter("smtpCheckUser");
        String smtpCheckPassword = request.getParameter("smtpCheckPassword");
        String smtpCheckPort = request.getParameter("smtpCheckPort");
        String smtpCheckTimeout = request.getParameter("smtpCheckTimeout");

        /* m[hĎ񐶐 */
        NodeInformation nodeInformation = new NodeInformation();

        nodeInformation.setEngineAddress(engineAddress);
        nodeInformation.setNodename(nodeName);
        nodeInformation.setIpaddress(ipAddress);
        nodeInformation.setGroup(group);
        nodeInformation.setNodeKind(nodeKind);

        /* PingĎ */
        nodeInformation.setPingPeriod(pingPeriod);
        nodeInformation.setPingThreshold(pingThreshold);

        /* SNMPĎ */
        nodeInformation.setSnmpVersion(snmpVersion);
        nodeInformation.setSnmpPeriod(snmpPeriod);
        nodeInformation.setSnmpLevel(snmpLevel);
        nodeInformation.setRoCommunity(roCommunity);
        nodeInformation.setRwCommunity(rwCommunity);
        nodeInformation.setHttpPeriod(httpPeriod);
        nodeInformation.setHttpUrl(httpUrl);
        nodeInformation.setHttpTimeout(httpTimeout);

        /* PopĎ */
        nodeInformation.setPopPeriod(popPeriod);
        nodeInformation.setPopUser(popUser);
        nodeInformation.setPopPassword(popPassword);
        nodeInformation.setPopPort(popPort);
        nodeInformation.setPopTimeout(popTimeout);

        /* SMTPĎ */
        nodeInformation.setSmtpPeriod(smtpPeriod);
        nodeInformation.setSmtpPort(smtpPort);
        nodeInformation.setSmtpTimeout(smtpTimeout);
        nodeInformation.setSmtpSendAddress(smtpSendAddress);
        nodeInformation.setSmtpCheckHost(smtpCheckHost);
        nodeInformation.setSmtpCheckUser(smtpCheckUser);
        nodeInformation.setSmtpCheckPassword(smtpCheckPassword);
        nodeInformation.setSmtpCheckPort(smtpCheckPort);
        nodeInformation.setSmtpCheckTimeout(smtpCheckTimeout);

        return nodeInformation;
    }
}
