/*
 * Created on 2004/05/17
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.nodemanager.list;

import java.net.InetAddress;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import netjfwatcher.preference.Preference;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * m[h}l[Wɂȉ̃t[ZbgJSPNANVNXłB
 * EXML Socketڑt[
 * Em[hXgƃA[\t[
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeManagerFrameAction extends Action {
    private static Logger logger = null;

    public ActionForward execute(
        ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception {
        logger = Logger.getLogger(this.getClass().getName());

        String engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (engineAddress == null) {
            engineAddress = "localhost";
            logger.warning("Not Engine Addreess : " + engineAddress);
        }

        String servernamework1 =
            InetAddress.getLocalHost().toString().replace('.', '_');
        String servernamework2 = servernamework1.replace('/', '_');
        String servername = servernamework2.replace('-', '_');

        request.setAttribute(Preference.SERVER_NAME, servername);
        request.setAttribute(Preference.ENGINE_ADDRESS, engineAddress);

        HttpSession session = request.getSession();
        String authMode = (String) session.getAttribute(Preference.AUTH_MODE);

        if (authMode == null) {
            // session.setAttribute("authmode", "noauth");
            session.setAttribute(
                Preference.AUTH_MODE, Preference.AUTH_MODE_AUTH);
        }

        // session.setAttribute("authmode", "noauth");
        return mapping.findForward(Preference.SUCCESS);
    }
}
