/*
 * Created on 2004/07/14
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.miboperation;

import java.util.ArrayList;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.engine.socket.info.MibInfo;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.miboperation.model.SnmpObjectType;
import netjfwatcher.noderegister.NodeAddViewAction;
import netjfwatcher.noderegister.model.NodeRegisterModel;
import netjfwatcher.preference.Preference;
import netjfwatcher.resourceconfig.EngineResourceConfig;
import netjfwatcher.resourceconfig.EngineResourceInfo;
import netjfwatcher.snmp.preference.SnmpBERCodec;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * MIBݒJSPփtH[hANVNXłB
 * p[^ƂIPAhXw肳Ăꍇ́AIPAhXƑΉCommunityԂ܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class MibSetOperationFrameAction extends Action {
    /* SNMP Object Typez */
    private static final String[] SNMP_TYPE_ARRAY =
    {
        SnmpBERCodec.SNMPINTEGER, SnmpBERCodec.SNMPCOUNTER32,
        SnmpBERCodec.SNMPCOUNTER64, SnmpBERCodec.SNMPGAUGE32,
        SnmpBERCodec.SNMPOCTETSTRING, SnmpBERCodec.SNMPIPADDRESS,
        SnmpBERCodec.SNMPOBJECTIDENTIFIER, SnmpBERCodec.SNMPTIMETICKS,
        SnmpBERCodec.SNMPUINTEGER32, SnmpBERCodec.SNMPBITSTRING,
        SnmpBERCodec.SNMPOPAQUE,
    };

    /* MO */
    private static Logger logger;

    public ActionForward execute(
        ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception {
        logger = Logger.getLogger(this.getClass().getName());

        String engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (engineAddress == null) {
            logger.warning("Not Engine Address");
            engineAddress = "localhost";
        }

        String ipaddress = request.getParameter(Preference.IPADDRESS);

        NodeInformation nodeInfo = null;

        if (!engineAddress.equals("all")) {
            NodeRegisterModel nodeinfomodel = new NodeRegisterModel();
            nodeInfo = nodeinfomodel.getIPTarget(engineAddress, ipaddress);
        }

        String rwCommunity = NodeAddViewAction.INITIAL_NODE_SNMP_RWCOMMUNITY;
        String roCommunity = NodeAddViewAction.INITIAL_NODE_SNMP_ROCOMMUNITY;
        String version = NodeAddViewAction.INITIAL_NODE_SNMP_VERSION;

        if (nodeInfo != null) {
            rwCommunity = nodeInfo.getRwCommunity();
            roCommunity = nodeInfo.getRoCommunity();
            version = nodeInfo.getSnmpVersion();
        }

        MibInfo mibInfo = new MibInfo();
        mibInfo.setIpaddress(ipaddress);
        mibInfo.setVersionString(version);
        mibInfo.setRwCommunity(rwCommunity);
        mibInfo.setRoCommunity(roCommunity);

        // request.setAttribute("ipaddress", ipaddress);
        request.setAttribute(Preference.SNMP_MIB_INFO, mibInfo);

        ArrayList engineInfoList = null;

        if (engineAddress.equals("all")) {
            engineInfoList =
                EngineResourceConfig.getInstance().getEngineInfo()
                                    .getEngineInfoList();
        } else {
            EngineResourceInfo engineInfo = new EngineResourceInfo();
            engineInfo.setEngineIPaddress(engineAddress);
            engineInfoList = new ArrayList();
            engineInfoList.add(engineInfo);
        }

        ArrayList writeValueTypeList = new ArrayList();
        SnmpObjectType writeValueType;
        writeValueType = new SnmpObjectType();
        writeValueType.setWriteValueType("Auto");
        writeValueTypeList.add(writeValueType);

        for (int i = 0; SNMP_TYPE_ARRAY.length > i; i++) {
            writeValueType = new SnmpObjectType();
            writeValueType.setWriteValueType(SNMP_TYPE_ARRAY[i]);
            writeValueTypeList.add(writeValueType);
        }

        request.setAttribute(
            Preference.SNMP_MIB_WRITE_VALUE_TYPE_LIST, writeValueTypeList);
        request.setAttribute(Preference.ENGINE_INFO_LIST, engineInfoList);
        request.setAttribute(Preference.ENGINE_ADDRESS, engineAddress);

        return mapping.findForward(Preference.SUCCESS);
    }
}
