/*
 * Created on 2004/07/07
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.miboperation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.MibGetResponse;
import netjfwatcher.engine.socket.info.MibGetResponseList;
import netjfwatcher.miboperation.model.MibGetModel;
import netjfwatcher.preference.Preference;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * MIBݒɂĐݒ{^̃ANVsANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class MibSetAction extends Action {
    /* MO */
    private static Logger logger = null;

    /* GWAhX */
    private String engineAddress;

    /* MIB Get/Set[h */
    private String mode = "";

    /* m[hIPAhX */
    private String ipaddress = "";

    /* SNMPo[W */
    private String version = "";

    /* Read/WriteR~jeB */
    private String rwCommunity = "";

    /* ReadR~jeB */
    private String roCommunity = "";

    /* OID */
    private String requestOid = "";

    /* Write(Set Request)f[^ */
    private String writeValue = "";

    /* Write(Set Request) SNMPIuWFNgType */
    private String writeValueType = "";

    public ActionForward execute(
        ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception {
        logger = Logger.getLogger(this.getClass().getName());

        engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (engineAddress == null) {
            logger.warning("Not Engine Address");
            engineAddress = "localhost";
        }

        if (request.getParameter("Set") != null) {
            mode = "Set";
        } else {
            mode = "Get";
        }

        ipaddress = request.getParameter(Preference.IPADDRESS);
        version = request.getParameter(Preference.SNMP_VERSION_STRING);

        if (request.getParameter(Preference.SNMP_RW_COMMUNITY) != null) {
            rwCommunity = request.getParameter(Preference.SNMP_RW_COMMUNITY);
        }

        if (request.getParameter(Preference.SNMP_RO_COMMUNITY) != null) {
            roCommunity = request.getParameter(Preference.SNMP_RO_COMMUNITY);
        }

        if (request.getParameter(Preference.SNMP_REQUEST_MIB_OID) != null) {
            requestOid = request.getParameter(Preference.SNMP_REQUEST_MIB_OID);
        } else {
            requestOid = request.getParameter(Preference.SNMP_MIB_OID);
        }

        if (request.getParameter(Preference.SNMP_MIB_WRITE_VALUE) != null) {
            writeValue = request.getParameter(Preference.SNMP_MIB_WRITE_VALUE);
        } else {
            writeValue = request.getParameter(Preference.SNMP_MIB_VALUE);
        }

        if (request.getParameter(Preference.SNMP_MIB_WRITE_VALUE_TYPE) != null) {
            writeValueType =
                request.getParameter(Preference.SNMP_MIB_WRITE_VALUE_TYPE);
        } else {
            writeValueType = "Auto";
        }

        if (!mode.equals("Get")) {
            if (setMib(request)) {
                return mapping.findForward(Preference.SUCCESS);
            } else {
                return mapping.findForward(Preference.ABORT);
            }
        } else {
            if (getMib(request)) {
                return mapping.findForward(Preference.SUCCESS);
            } else {
                return mapping.findForward(Preference.ABORT);
            }
        }
    }

    private boolean setMib(HttpServletRequest request)
        throws EngineConnectException, IOException {
        MibGetModel mibgetmodel = new MibGetModel();

        MibGetResponseList mibGetPesponseList = null;

        mibGetPesponseList =
            mibgetmodel.setMib(
                engineAddress, ipaddress, version, rwCommunity, requestOid,
                writeValue, writeValueType);

        String result = mibGetPesponseList.getResultCode();

        if (result.equals("OK")) {
            ArrayList list = mibGetPesponseList.getMibgetresponseList();

            for (int i = 0; i < list.size(); i++) {
                MibGetResponse mibgetresponse = (MibGetResponse) list.get(i);
                System.out.println(mibgetresponse.getMibValue());
            }

            int arraysize = list.size();
            ArrayList formlist = new ArrayList();
            request.setAttribute(Preference.SNMP_MIB_GET_LIST, list);

            request.setAttribute(Preference.ENGINE_ADDRESS, engineAddress);
            request.setAttribute(
                Preference.SNMP_STATISTICS_TARGET_IPADDRESS, ipaddress);
            request.setAttribute(Preference.SNMP_VERSION, version);
            request.setAttribute(Preference.SNMP_READ_COMMUNITY, rwCommunity);

            // return mapping.findForward("success");
            return true;
        } else {
            request.setAttribute("result", result);
            logger.warning("MIB Set Abort Result : " + result);

            // return mapping.findForward("abort");
            return false;
        }
    }

    private boolean getMib(HttpServletRequest request)
        throws EngineConnectException, IOException {
        MibGetModel mibgetmodel = new MibGetModel();
        MibGetResponseList mibGetPesponseList = null;
        mibGetPesponseList =
            mibgetmodel.getMib(
                engineAddress, ipaddress, version, roCommunity, requestOid);

        String result = mibGetPesponseList.getResultCode();

        // MIB̎ɐꍇ		
        if (result.equals("OK")) {
            ArrayList list = mibGetPesponseList.getMibgetresponseList();

            for (int i = 0; i < list.size(); i++) {
                MibGetResponse mibgetresponse = (MibGetResponse) list.get(i);

                System.out.println(mibgetresponse.getMibValue());
            }

            request.setAttribute(Preference.ENGINE_ADDRESS, engineAddress);
            request.setAttribute(
                Preference.SNMP_STATISTICS_TARGET_IPADDRESS, ipaddress);
            request.setAttribute(Preference.SNMP_VERSION, version);
            request.setAttribute(Preference.SNMP_READ_COMMUNITY, rwCommunity);
            request.setAttribute(Preference.SNMP_MIB_GET_LIST, list);

            return true;

            // MIB̎Ɏsꍇ
        } else {
            request.setAttribute(Preference.SNMP_MIB_OP_RESULT, result);
            logger.warning("MIB Get Abort Result : " + result);

            return false;
        }
    }
}
