/*
 * Created on 2004/07/02
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.maintenance.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Logger;

import netjfwatcher.engine.socket.ConnectionTaskScheduleControl;
import netjfwatcher.engine.socket.EngineConnectException;


/**
 * ^XNXPW[̑GWɒʒm郁\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class TaskScheduleControlModel {
    private static Logger logger = null;


    public TaskScheduleControlModel() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * ^XNXPW[ݒ肵܂B
     *
     * @param engineAddress GWAhX
     * @param taskStartDate ^XNJn
     * @param taskEndDate ^XNI
     * @throws EngineConnectException GWƂ̐ڑňُ킪ꍇ
     * @throws IOException GWƂ̐ڑňُ킪ꍇ
     */
    public void setTaskSchedule(
        String engineAddress, Date taskStartDate, Date taskEndDate)
        throws EngineConnectException, IOException {
        logger.info(engineAddress);

        ConnectionTaskScheduleControl taskSchedule =
            new ConnectionTaskScheduleControl(engineAddress);

        taskSchedule.setTaskSchedule(taskStartDate, taskEndDate);
    }

    /**
     * ^XNXPW[GW擾ĕԂ܂B
     *
     * @param engineAddress GWAhX
     * @return list ^XNXPW[񃊃Xg
     * @throws EngineConnectException GWƂ̐ڑňُ킪ꍇ
     * @throws IOException GWƂ̐ڑňُ킪ꍇ
     */
    public ArrayList getTaskSchedule(String engineAddress)
        throws EngineConnectException, IOException {
        logger.info(engineAddress);

        ConnectionTaskScheduleControl taskSchedule =
            new ConnectionTaskScheduleControl(engineAddress);

        ArrayList list = taskSchedule.getTaskSchedule();

        return list;
    }

    /**
     * wTask IDLZ܂B
     *
     * @param engineAddress GWAhX
     * @param taskId ^XNID
     * @throws EngineConnectException GWƂ̐ڑňُ킪ꍇ
     * @throws IOException GWƂ̐ڑňُ킪ꍇ
     */
    public void cancelTaskSchedule(String engineAddress, String taskId)
        throws EngineConnectException, IOException {
        logger.info(engineAddress);

        ConnectionTaskScheduleControl taskSchedule =
            new ConnectionTaskScheduleControl(engineAddress);

        taskSchedule.cancelTaskSchedule(taskId);
    }
}
