/*
 * Created on 2004/06/02
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.maintenance.model;

import java.io.IOException;
import java.util.logging.Logger;

import netjfwatcher.engine.socket.ConnectionMailSendTest;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.MailSendTestInformation;


/**
 * MailMeXgsNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class MailSendTestModel {
    /* MO */
    private static Logger logger = null;

    public MailSendTestModel() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * MailMeXgs܂B
     *
     * @param engineAddress GWAhX
     * @param smtpHost SMTPzXg
     * @param mailFrom Mail From
     * @param mailTo Mail To
     * @param mailSubject Mail Subject
     * @param mailBody Mail Body
     * @return mailTestResult MailMeXg
     */
    public String executeMailSend(
        String engineAddress, String smtpHost, String mailFrom, String mailTo,
        String mailSubject, String mailBody)
        throws EngineConnectException, IOException {
        // logger.info("engineAddress : " + engineAddress);
        ConnectionMailSendTest mailSend =
            new ConnectionMailSendTest(engineAddress);

        MailSendTestInformation mailInfo = new MailSendTestInformation();
        mailInfo.setSmtpHost(smtpHost);
        mailInfo.setMailFrom(mailFrom);
        mailInfo.setMailTo(mailTo);
        mailInfo.setMailSubject(mailSubject);
        mailInfo.setMailBody(mailBody);

        String mailTestResult = "";

        try {
            mailTestResult = mailSend.testMailSend(mailInfo);
        } catch (EngineConnectException e) {
            logger.warning("Abort test mail send : " + e.getMessage());
            mailTestResult = "Abort connect engine : " + e.getMessage();
        } catch (IOException e) {
            logger.warning("Abort test mail send : " + e.getMessage());
            mailTestResult = "Abort connect engine : " + e.getMessage();
        }

        logger.info("mailTestResult : " + mailTestResult);

        return mailTestResult;
    }
}
