/*
 * Created on 2004/12/01
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.maintenance.model;

import java.io.IOException;
import java.util.logging.Logger;

import netjfwatcher.engine.socket.ConnectionGarbageCollection;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.GarbageCollectionControl;


/**
 * GarbageCollectionj^擾NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class GarbageCollectionMonitorModel {
    /* MO */
    private static Logger logger;


    public GarbageCollectionMonitorModel() {
        logger = Logger.getLogger(this.getClass().getName());
    }


    public GarbageCollectionControl sartGarbageCollectionThread(
        String engineAddress, String interval) {
        GarbageCollectionControl info = null;
        ConnectionGarbageCollection garbage =
            new ConnectionGarbageCollection(engineAddress);

        try {
            info = garbage.startGarbageCollection(interval);
        } catch (EngineConnectException e) {
            logger.warning("Abort connect engine : " + e.getMessage());
        } catch (IOException e) {
            logger.warning("Abort connect engine : " + e.getMessage());
        }

        return info;
    }


    public GarbageCollectionControl stopGarbageCollectionThread(
        String engineAddress) {
        GarbageCollectionControl garbageCollectionInfo = null;
        ConnectionGarbageCollection garbage =
            new ConnectionGarbageCollection(engineAddress);

        try {
            garbageCollectionInfo = garbage.stopGarbageCollection();
        } catch (EngineConnectException e) {
            logger.warning("Abort connect engine : " + e.getMessage());
        } catch (IOException e) {
            logger.warning("Abort connect engine : " + e.getMessage());
        }

        return garbageCollectionInfo;
    }


    public GarbageCollectionControl getGarbageCollectionInfo(
        String engineAddress, String startTime, String endTime) {
        GarbageCollectionControl garbageCollectionInfo = null;
        ConnectionGarbageCollection garbage =
            new ConnectionGarbageCollection(engineAddress);

        try {
            garbageCollectionInfo =
                garbage.getGarbageCollectionInfo(startTime, endTime);
        } catch (EngineConnectException e) {
            logger.warning("Abort connect engine : " + e.getMessage());
        } catch (IOException e) {
            logger.warning("Abort connect engine : " + e.getMessage());
        }

        return garbageCollectionInfo;
    }
}
