/*
 * Created on 2004/05/28
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.maintenance.model;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

import netjfwatcher.preference.Preference;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;


/**
 * Flash\[XXMLt@C͂AFlashpIcon摜t@CpXA
 * TEht@CpXێNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class FlashResourceInformationModel {


    /* Logging */
    private static Logger logger = null;

    /* IconxXg */
    private ArrayList iconLabelList = new ArrayList();

    /* Iconf[^Xg */
    private ArrayList iconDataList = new ArrayList();

    /* TEht@CXg */
    private ArrayList soundFileList = new ArrayList();

    /**
     * Flash\[XXMLt@C͂AFlashpIcon摜t@CpXA
     * TEht@CpXێNXCX^X𐶐܂B
     *
     */
    public FlashResourceInformationModel() {
        logger = Logger.getLogger(this.getClass().getName());

        Document doc = getDocument();

        try {
            /* rootvfo */
            Element root = doc.getRootElement();

            /* SoundyIcon NodeXgZbg*/
            List soundList = root.getChildren("Sound");
            List iconList = root.getChildren("Icon");

            /*
             * Soundt@CpXXgZbg
             */
            Iterator iterator = soundList.iterator();

            while (iterator.hasNext()) {
                Element soundFileEl = (Element) iterator.next();
                soundFileList.add(
                    soundFileEl.getChild("sound_file").getAttributeValue(
                        "value"));
            }

            /*
             * Icon摜t@CpXXgZbg
             */
            iterator = iconList.iterator();

            while (iterator.hasNext()) {
                Element iconLabelEl = (Element) iterator.next();
                iconLabelList.add(
                    iconLabelEl.getChild("Icon_Label").getAttributeValue(
                        "value"));
                iconDataList.add(
                    iconLabelEl.getChild("Icon_Data").getAttributeValue(
                        "value"));
            }
        } catch (NullPointerException e) {
            e.printStackTrace();
            logger.warning("NullPointerException " + e.getMessage());
        }
    }

    /**
     * Flash\[XXMLt@CDocument𐶐ĕԂ܂B
     * @return doc Document
     */
    private Document getDocument() {
        Document doc = null;

        try {
            /* Flash\[Xt@C */
            ClassLoader loader =
                FlashResourceInformationModel.class.getClassLoader();
            URL url = loader.getResource(Preference.FLASH_RESOURCE_XML_FILE);

            if (url == null) {
                /* Flash\[Xt@CȂꍇMO̎ */
                logger.severe("Not Found Flash Resource XML file url : " + url);
            }

            SAXBuilder builder = new SAXBuilder();
            doc = builder.build(url.openStream());
        } catch (JDOMException e) {
            e.printStackTrace();
            logger.warning("JDOMException " + e.getMessage());
        } catch (NullPointerException e) {
            e.printStackTrace();
            logger.warning("NullPointerException " + e.getMessage());
        } catch (IOException e) {
            e.printStackTrace();
            logger.warning("NullPointerException " + e.getMessage());
        }

        return doc;
    }

    /**
     * Iconf[^XgԂ܂B
     *
     * @return iconDataList Iconf[^Xg
     */
    public ArrayList getIconDataList() {
        return iconDataList;
    }

    /**
     * IconxXgԂ܂B
     *
     * @return iconLabelList IconxXg
     */
    public ArrayList getIconLabelList() {
        return iconLabelList;
    }

    /**
     * TEht@CXgԂ܂B
     *
     * @return soundFileList TEht@CXg
     */
    public ArrayList getSoundFileList() {
        return soundFileList;
    }
}
