/*
 * Created on 2004/07/02
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.maintenance.flashaction;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Logger;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.TaskScheduleInfo;
import netjfwatcher.maintenance.model.TaskScheduleControlModel;
import netjfwatcher.preference.Preference;


/**
 * Flash̃^XNXPW[sT[ubgNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class TaskScheduleControlAction extends HttpServlet {
    private static Logger logger = null;
    private String engineAddress = null;

    public void doPost(
        HttpServletRequest request, HttpServletResponse response)
        throws IOException, ServletException {
        logger = Logger.getLogger(this.getClass().getName());

        engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (engineAddress == null) {
            logger.warning("Not found engine address");
        }

        String mode = request.getParameter("mode");

        try {
            if (mode.equals("load")) {
                this.loadTaskSchedule(request, response);
            } else if (mode.equals("set")) {
                this.setTaskSchedule(request, response);
            } else if (mode.equals("cancel")) {
                this.cancelTaskSchedule(request, response);
            }
        } catch (EngineConnectException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        } catch (IOException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
    }

    private void setTaskSchedule(
        HttpServletRequest request, HttpServletResponse response)
        throws EngineConnectException, IOException {
        String mode = request.getParameter("mode");
        String postStartYY = request.getParameter("start_yy");
        String postStartMM = request.getParameter("start_mm");
        String postStartDD = request.getParameter("start_dd");
        String postStartHH = request.getParameter("start_hh");
        String postStartMIN = request.getParameter("start_min");
        String postEndYY = request.getParameter("end_yy");
        String postEndMM = request.getParameter("end_mm");
        String postEndDD = request.getParameter("end_dd");
        String postEndHH = request.getParameter("end_hh");
        String postEndMIN = request.getParameter("end_min");
        int startYY = Integer.parseInt(postStartYY);
        int startMM = Integer.parseInt(postStartMM);
        int startDD = Integer.parseInt(postStartDD);
        int startHH = Integer.parseInt(postStartHH);
        int startMIN = Integer.parseInt(postStartMIN);
        int endYY = Integer.parseInt(postEndYY);
        int endMM = Integer.parseInt(postEndMM);
        int endDD = Integer.parseInt(postEndDD);
        int endHH = Integer.parseInt(postEndHH);
        int endMIN = Integer.parseInt(postEndMIN);

        Calendar cal = Calendar.getInstance();
        cal.set(startYY, startMM - 1, startDD, startHH, startMIN, 0);

        Date startDate = cal.getTime();
        cal.set(endYY, endMM - 1, endDD, endHH, endMIN, 0);

        Date endDate = cal.getTime();

        /*
        System.out.println("startDate : " + startDate.toString());
        System.out.println("endDate : " + endDate.toString());
        System.out.println("mode : " + mode);
        */
        TaskScheduleControlModel taskScheduleControl =
            new TaskScheduleControlModel();

        taskScheduleControl.setTaskSchedule(engineAddress, startDate, endDate);

        response.setContentType("text/plain");

        PrintWriter out = response.getWriter();

        out.print("OK");
    }

    private void loadTaskSchedule(
        HttpServletRequest request, HttpServletResponse response)
        throws EngineConnectException, IOException {
        DateFormat dateformat;

        //dateformat = DateFormat.getDateTimeInstance();
        dateformat =
            new SimpleDateFormat("yyyy-MM-dd (EEE) HH:mm:ss", Locale.US);

        TaskScheduleControlModel taskScheduleControl =
            new TaskScheduleControlModel();

        ArrayList list = taskScheduleControl.getTaskSchedule(engineAddress);
        String[] taskId = new String[list.size()];
        String[] taskStartDate = new String[list.size()];
        String[] taskEndDate = new String[list.size()];

        for (int i = 0; i < list.size(); i++) {
            TaskScheduleInfo info = (TaskScheduleInfo) list.get(i);
            taskId[i] = Integer.toString(info.getId());

            Date date = info.getTaskStartDate();
            taskStartDate[i] = dateformat.format(date);
            date = info.getTaskEndDate();
            taskEndDate[i] = dateformat.format(date);
        }

        response.setContentType("text/plain");

        PrintWriter out = response.getWriter();

        out.print("taskCount=" + list.size());

        // System.out.println("taskCount=" + list.size());
        int taskCount;

        for (taskCount = 0; taskCount < list.size(); taskCount++) {
            out.print("&taskId" + taskCount + "=" + taskId[taskCount]);
            out.print(
                "&taskStart" + taskCount + "=" + taskStartDate[taskCount]);
            out.print("&taskEnd" + taskCount + "=" + taskEndDate[taskCount]);
        }
    }

    private void cancelTaskSchedule(
        HttpServletRequest request, HttpServletResponse response)
        throws EngineConnectException, IOException {
        String mode = request.getParameter("mode");
        String postTaskId = request.getParameter("cancelTaskId");

        TaskScheduleControlModel taskScheduleControl =
            new TaskScheduleControlModel();

        taskScheduleControl.cancelTaskSchedule(engineAddress, postTaskId);

        response.setContentType("text/plain");

        PrintWriter out = response.getWriter();

        out.print("OK");
    }
}
