/*
 * Created on 2003/08/24
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.maintenance.action;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.maintenance.model.XMLSocketStateModel;
import netjfwatcher.preference.Preference;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * XML SocketڑԂ\ANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class XMLSocketStateAction extends Action {
    private static Logger logger = null;

    public ActionForward execute(
        ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception {
        logger = Logger.getLogger(this.getClass().getName());

        String engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (engineAddress == null) {
            logger.warning("Not server Address");
        }

        XMLSocketStateModel socketstate = new XMLSocketStateModel();
        ArrayList xmlSocketConnectList = socketstate.getList(engineAddress);

        /*
        for (int i = 0; i < xmlSocketConnectList.size(); i++) {
        XMLSocketConnectState connectstate =
        (XMLSocketConnectState) xmlSocketConnectList.get(i);
        System.out.println(
        "Mainte check remote ip : " + connectstate.getRemoteIP());
        System.out.println(
        "Mainte check start time : " + connectstate.getStartTime());
        }
        */
        request.setAttribute("xmlsocketconnectstateList", xmlSocketConnectList);

        String servernamework1 =
            InetAddress.getLocalHost().toString().replace('.', '_');
        String servernamework2 = servernamework1.replace('/', '_');
        String servername = servernamework2.replace('-', '_');
        request.setAttribute(Preference.SERVER_NAME, servername);
        request.setAttribute(Preference.ENGINE_ADDRESS, engineAddress);

        return mapping.findForward(Preference.SUCCESS);
    }
}
