/*
 * Created on 2004/05/18
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.maintenance.action;

import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.engine.socket.info.ResourceInfo;
import netjfwatcher.maintenance.model.ResourceManagementModel;
import netjfwatcher.preference.Preference;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * \[XXVANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ResourceSetAction extends Action {
    /* MO */
    private static Logger logger = null;

    public ActionForward execute(
        ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception {
        logger = Logger.getLogger(this.getClass().getName());

        String serverAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (serverAddress == null) {
            logger.warning("Not server Address");
        }

        // Updatep\[XZbg
        ResourceInfo resourceInfo = new ResourceInfo();
        resourceInfo.setDatabaseName(request.getParameter("database_name"));
        resourceInfo.setDatabaseDriver(request.getParameter("database_driver"));
        resourceInfo.setDatabaseUrl(request.getParameter("database_url"));
        resourceInfo.setDatabaseUser(request.getParameter("database_user"));
        resourceInfo.setDatabasePassword(
            request.getParameter("database_password"));
        resourceInfo.setSnmpV1Timeout(request.getParameter("snmp_timeout"));
        resourceInfo.setSnmpV1Retry(request.getParameter("snmp_retry"));
        resourceInfo.setPingTimeout(request.getParameter("ping_timeout"));
        resourceInfo.setPingRetry(request.getParameter("ping_retry"));
        resourceInfo.setAlertSound(request.getParameter("alert_sound"));
        resourceInfo.setXmlSocketPort(request.getParameter("xmlsocket_port"));
        resourceInfo.setXmlSocketMaxConnect(
            request.getParameter("xmlsocket_maxconnect"));

        ResourceManagementModel nodeedit = new ResourceManagementModel();

        ResourceInfo resultResourceInfo =
            nodeedit.updateResource(serverAddress, resourceInfo);

        request.setAttribute("resourceList", resultResourceInfo);

        return mapping.findForward(Preference.SUCCESS);
    }
}
