/*
 * Created on 2004/06/03
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.maintenance.action;

import java.util.ArrayList;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.library.ClientFlashInfo;
import netjfwatcher.preference.Preference;
import netjfwatcher.resourceconfig.EngineResourceConfig;
import netjfwatcher.resourceconfig.EngineResourceInfo;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * ێ}l[W\[X\FlashɃ\[X𑗂ANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ResourceManagementControlPreAction extends Action {
    private static Logger logger = null;

    public ActionForward execute(
        ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception {
        logger = Logger.getLogger(this.getClass().getName());

        String engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (engineAddress == null) {
            ArrayList engineList =
                EngineResourceConfig.getInstance().getEngineInfo()
                                    .getEngineInfoList();
            engineAddress =
                ((EngineResourceInfo) engineList.get(0)).getEngineIPaddress();
        }

        ClientFlashInfo clientInfo = new ClientFlashInfo();
        request = clientInfo.getClientFlashInfo(engineAddress, request);

        request.setAttribute(
            Preference.REFRESH_TIMER, Preference.REFRESH_TIMER_SHOW);
        request.setAttribute(Preference.ENGINE_ADDRESS, engineAddress);

        return mapping.findForward(Preference.SUCCESS);
    }
}
