/*
 * Created on 2003/08/23
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.maintenance.action;

import java.net.InetAddress;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.preference.Preference;
import netjfwatcher.resourceconfig.EngineResourceConfig;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * ێ}l[Wt[ZbgANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class MaintenanceFrameAction extends Action {
    private static Logger logger = null;

    public ActionForward execute(
        ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception {
        String servername;

        logger = Logger.getLogger(this.getClass().getName());

        String engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (engineAddress == null) {
            logger.warning("Not Engine Address");
            engineAddress = "all";
        }

        servername = request.getParameter(Preference.SERVER_NAME);

        if (servername == null) {
            String servernamework1 =
                InetAddress.getLocalHost().toString().replace('.', '_');
            String servernamework2 = servernamework1.replace('/', '_');
            servername = servernamework2.replace('-', '_');
        }

        String clientXmlSocketPort =
            EngineResourceConfig.getInstance().getEngineInfo()
                                .getClientXmlSocketPort();
        request.setAttribute(Preference.SERVER_NAME, servername);
        request.setAttribute(
            Preference.CLIENT_XML_SOCKET_PORT, clientXmlSocketPort);
        request.setAttribute(Preference.ENGINE_ADDRESS, engineAddress);

        return mapping.findForward(Preference.SUCCESS);
    }
}
