/*
 * Created on 2004/08/11
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.maintenance.action;

import java.net.InetAddress;
import java.util.ArrayList;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.preference.Preference;
import netjfwatcher.resourceconfig.EngineResourceConfig;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * ێ}l[W̃j[t[\ANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class MainteMenuAction extends Action {
    public ActionForward execute(
        ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception {
        String servernamework1 =
            InetAddress.getLocalHost().toString().replace('.', '_');
        String servernamework2 = servernamework1.replace('/', '_');
        String servername = servernamework2.replace('-', '_');

        String clientXmlSocketPort =
            EngineResourceConfig.getInstance().getEngineInfo()
                                .getClientXmlSocketPort();

        request.setAttribute(Preference.SERVER_NAME, servername);
        request.setAttribute(
            Preference.CLIENT_XML_SOCKET_PORT, clientXmlSocketPort);

        ArrayList engineInfoList =
            EngineResourceConfig.getInstance().getEngineInfo()
                                .getEngineInfoList();
        request.setAttribute(Preference.ENGINE_INFO_LIST, engineInfoList);

        return mapping.findForward("success");
    }
}
