/*
 * Created on 2004/08/02
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.library;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.resourceconfig.EngineResourceConfig;
import netjfwatcher.resourceconfig.EngineResourceInfo;
import netjfwatcher.engine.socket.ConnectionResourceGet;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.ResourceInfo;


/**
 * GW烊\[X擾VOgNXłB
 *
 * @author Yoshimasa matsumoto
 * @version 1.0
 */
public class ResourceInfoFromEngine {
    /* \[X */
    private static ResourceInfo resourceInfo = null;

    /* MO */
    private static Logger logger = null;

    // RXgN^privateɂĕspӂɒڃRXgN^Ăяoh~
    private ResourceInfoFromEngine() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * GW烊\[X擾ĕԂ܂B
     *
     * @param engineAddress GWAhX
     * @return ResourceInfo \[X
     * @throws EngineConnectException
     * @throws IOException
     */
    public ResourceInfo getResourceInfo(String engineAddress)
        throws EngineConnectException, IOException {
        if (resourceInfo == null) {
            logger.info("Resource from Engine");
            logger.info("Connect engineAddress : " + engineAddress);

            if (engineAddress.equals("all")) {
                ArrayList engineList =
                    EngineResourceConfig.getInstance().getEngineInfo()
                                        .getEngineInfoList();

                for (int i = 0; i < engineList.size(); i++) {
                    String testEngineAddress =
                        ((EngineResourceInfo) engineList.get(i))
                        .getEngineIPaddress();
                    logger.info("Check engine connect : " + testEngineAddress);

                    ArrayList workAlarmList = null;

                    ConnectionResourceGet resourceGet =
                        new ConnectionResourceGet(testEngineAddress);

                    try {
                        resourceInfo = resourceGet.getResource();
                    } catch (EngineConnectException e) {
                        logger.warning(e.getMessage());
                    } catch (IOException e) {
                        logger.warning(e.getMessage());
                    }
                }
            } else {
                ConnectionResourceGet resourceGet =
                    new ConnectionResourceGet(engineAddress);

                try {
                    resourceInfo = resourceGet.getResource();
                } catch (EngineConnectException e) {
                    e.printStackTrace();
                    logger.warning(e.getMessage());
                    throw e;
                } catch (IOException e) {
                    e.printStackTrace();
                    logger.warning(e.getMessage());
                    throw e;
                }
            }
        }

        return resourceInfo;
    }

    /**
     * \[Xt@C(XMLt@C)XVꂽꍇɁAێĂNXXV邽߂ɌĂ΂܂B
     *
     * @param engineAddress GWAhX
     * @throws EngineConnectException
     * @throws IOException
     */
    public void updateResourceset(String engineAddress)
        throws EngineConnectException, IOException {
        logger.info("Resource reload");
        resourceInfo = null;

        ConnectionResourceGet resourceGet =
            new ConnectionResourceGet(engineAddress);

        try {
            resourceInfo = resourceGet.getResource();
        } catch (EngineConnectException e) {
            e.printStackTrace();
            logger.warning(e.getMessage());
            throw e;
        } catch (IOException e) {
            e.printStackTrace();
            logger.warning(e.getMessage());
            throw e;
        }
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static ResourceInfoFromEngine getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final ResourceInfoFromEngine RESOURCE =
            new ResourceInfoFromEngine();
    }
}
