/*
 * Created on 2004/08/02
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.library;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;

import javax.servlet.http.HttpServletRequest;

import netjfwatcher.resourceconfig.EngineResourceConfig;
import netjfwatcher.resourceconfig.EngineResourceInfo;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.ResourceInfo;


/**
 * NCAgFlashpɃvpeBԂ\bh܂B
 *@ NCAgGWڑ̂߂Flash XML SocketɃZbgڑAhXyѐڑPortԍ
 *  CxgM̃TEh
 *  tbV^C}[
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ClientFlashInfo {
    /**
     * \[X񂩂ȉ̃f[^HttpServletRequest̑ɃZbg܂B
     * EXML SocketڑAhXAڑ|[g
     * EAlert Sound t@C
     * EtbV^C}[
     *
     * @param engineAddress GWAhX
     * @param request@HttpServletRequest
     * @return@request@HttpServletRequest
     * @throws EngineConnectException GWƂ̐ڑɈُ킪ꍇ
     * @throws IOException GWƂ̐ڑɈُ킪ꍇ܂́A
     * localhost擾Ɏsꍇ
     */
    public HttpServletRequest getClientFlashInfo(
        String engineAddress, HttpServletRequest request)
        throws EngineConnectException, IOException {
        String alertSound = "";
        String refreshTime = "300";
        ResourceInfo resourceInfo = null;

        /*
         * GWNCAgp̃\[X擾āANCAg
         * Ԃp[^Zbg
         */
        resourceInfo =
            ResourceInfoFromEngine.getInstance().getResourceInfo(engineAddress);

        if (resourceInfo != null) {
            alertSound = resourceInfo.getAlertSound();
            refreshTime = resourceInfo.getRefreshTime();
        }

        /*
         * Flash XML SocketڑpAhXyѐڑPortԍ
         * iڑGW݂ꍇ́AJ}','؂ŕZbgj
         */
        String clientAddress = request.getRemoteAddr();
        String engineIPAddress = "";
        String enginePort = "";

        if ((engineAddress == null) || engineAddress.equals("all")) {
            /*
             * GWAhXw肪'S'w肪ꍇ́ASẴGWAhX
             * ƐڑPortJ}','؂ŃZbg
             */
            engineIPAddress =
                EngineResourceConfig.getInstance().getEngineInfo()
                                    .getEngineIPAddress();

            ArrayList engineList =
                EngineResourceConfig.getInstance().getEngineInfo()
                                    .getEngineInfoList();

            /*
             * ڑGWXgǂݏoAAhXyѐڑ|[gf[^
             * p[^ƂăZbg
             */
            for (int i = 0; i < engineList.size(); i++) {
                EngineResourceInfo engineInfo =
                    (EngineResourceInfo) engineList.get(i);
                String workEngineAddress = "";
                String workEnginePort = "";
                workEngineAddress =
                    checkAddress(
                        clientAddress, engineInfo.getEngineIPaddress());
                workEnginePort = engineInfo.getEngineFlashXMLSocketPort();

                if (i == 0) {
                    engineIPAddress = workEngineAddress;
                    enginePort = workEnginePort;
                } else {
                    engineIPAddress += ("," + workEngineAddress);
                    enginePort += ("," + workEnginePort);
                }
            }
        } else {
            /*
             * ڑwGWAhX(SGWłȂꍇ)̏ꍇ
             */
            engineIPAddress = checkAddress(clientAddress, engineAddress);

            ArrayList engineList =
                EngineResourceConfig.getInstance().getEngineInfo()
                                    .getEngineInfoList();

            /*
             * ڑGWXgw̃GWAhXƐڑ|[go
             */
            boolean isFound = false;

            for (int i = 0; i < engineList.size(); i++) {
                EngineResourceInfo engineInfo =
                    (EngineResourceInfo) engineList.get(i);

                if (engineAddress.equals(engineInfo.getEngineIPaddress())) {
                    enginePort = engineInfo.getEngineFlashXMLSocketPort();
                    isFound = true;
                }
            }

            if (!isFound) {
                /*
                 * wGWAhXGWXgɖꍇAwGWAhXWebT[oAhX
                 * ƈv邩`FbN(GWAhXlocalł邩`FbN)
                 */
                String checkLocalEngineAddress = "";

                try {
                    checkLocalEngineAddress =
                        InetAddress.getLocalHost().getHostAddress();
                } catch (UnknownHostException e) {
                    e.printStackTrace();
                }

                if (engineAddress.equals(checkLocalEngineAddress)) {
                    /*
                     * wGWAhXWebT[oAhXƈvꍇɂ́A
                     * localAhXƂăGWXgv΁A
                     * YAhXƂA|[gԍ𒊏o
                     */
                    for (int i = 0; i < engineList.size(); i++) {
                        EngineResourceInfo engineInfo =
                            (EngineResourceInfo) engineList.get(i);

                        if ("127.0.0.1".equals(engineInfo.getEngineIPaddress())) {
                            enginePort =
                                engineInfo.getEngineFlashXMLSocketPort();

                            // engineIPAddress = "localhost";
                        }
                    }
                }
            }
        }

        /*
         * Client Flashp[^Zbg
         */
        request.setAttribute("timeData", refreshTime);
        request.setAttribute("alert_sound", alertSound);

        /*
         * ڑGWAhXyѐڑ|[gp[^Zbg
         */
        request.setAttribute("serverport", enginePort);
        request.setAttribute(
            "servername", checkAddress(clientAddress, engineIPAddress));

        return request;
    }

    /**
     * NCAgIPAhXƃNCAg - GWڑp̃GWIPAhX`FbN
     * āANCAgGWɐڑ邽߂IPAhXԂ܂B
     *
     * ́A
     * ENCAg̃GWւ̐ڑIPAhXFlash XMLSocketłlocalhostւ
     * ڑłIPAhXł͂ȂlocalhostɂȂƐڑłȂ
     *
     * EEngine IP Addresslocalhost܂127.0.0.1ƋLqꂽꍇɂ́A
    * @ClientlocalȊȌꍇXML SocketڑT[oAhXlocalhost܂́A
    * @127.0.0.1ȊO̒IPAhXƂKv
    *
     * @param clientAddress NCAgAhX
     * @param checkAddress GWAhX
     * @return checkEngineAddress ڑGWAhX
     * @throws UnknownHostException
     */
    private String checkAddress(String clientAddress, String checkAddress)
        throws UnknownHostException {
        String checkEngineAddress = checkAddress;

        /*
         * Flash XMLSocketłlocalhostւ̐ڑłIPAhXł͂ȂlocalhostɂȂ
         * ڑłȂ
         */
        if (checkAddress.equals("127.0.0.1")) {
            checkEngineAddress = "localhost";
        }

        /*
         * Engine IP Addresslocalhost܂127.0.0.1ƋLqꂽꍇɂ́A
         * ClientlocalȊȌꍇXML SocketڑT[oAhXlocalhost܂́A
         * 127.0.0.1ȊO̒IPAhXƂKv
         */
        if (
            !clientAddress.equals("127.0.0.1")
                && !clientAddress.equals("localhost")) {
            if (
                checkEngineAddress.equals("localhost")
                    || checkEngineAddress.equals("127.0.0.1")) {
                checkEngineAddress =
                    InetAddress.getLocalHost().getHostAddress();
            }
        }

        return checkEngineAddress;
    }
}
