/*
 * Created on 2003/08/03
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.graph.flashaction;

import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.socket.info.StatisticsMibInfo;
import netjfwatcher.engine.socket.info.StatisticsMibProperty;

import netjfwatcher.graph.model.StatisticsMibGraphModel;

import netjfwatcher.noderegister.model.NodeRegisterModel;

import netjfwatcher.preference.Preference;

import java.io.IOException;
import java.io.PrintWriter;

import java.text.DateFormat;
import java.text.SimpleDateFormat;

import java.util.ArrayList;
import java.util.logging.Logger;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


/**
 * vOt\\sANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class StatisGraphAction extends HttpServlet {
    private static Logger logger = null;

    public void doPost(
        HttpServletRequest request, HttpServletResponse response)
        throws IOException, ServletException {
        logger = Logger.getLogger(this.getClass().getName());

        /* \Jn */
        String startTime =
            request.getParameter(Preference.START_YY) + "-"
            + request.getParameter(Preference.START_MM) + "-"
            + request.getParameter(Preference.START_DD) + " "
            + request.getParameter(Preference.START_HH) + ":"
            + request.getParameter(Preference.START_MIN) + ":00.0";

        /* \I */
        String endTime =
            request.getParameter(Preference.END_YY) + "-"
            + request.getParameter(Preference.END_MM) + "-"
            + request.getParameter(Preference.END_DD) + " "
            + request.getParameter(Preference.END_HH) + ":"
            + request.getParameter(Preference.END_MIN) + ":00.0";

        /*
        System.out.println("starttime : " + startTime);
        System.out.println("endtime : " + endTime);
        */
        String engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);
        String nodeIPAddress = request.getParameter(Preference.IPADDRESS);
        String mode = request.getParameter(Preference.GRAPH_MODE);
        String oid = request.getParameter(Preference.SNMP_OID);
        String instance = request.getParameter(Preference.SNMP_OID_INSTANCE);
        String notchMode = request.getParameter(Preference.GRAPH_NOTCH);

        /*
        System.out.println("node_ipaddress : " + nodeIPAddress);
        System.out.println("node_oid : " + oid);
        System.out.println("node_instance : " + instance);
        System.out.println("mode : " + mode);
        */
        int itemNum =
            Integer.parseInt(
                request.getParameter(Preference.GRAPH_ITEM_NUMBER));

        String mibUnit = "";

        int dataCnt;
        String[] resTime;
        String[] resDate;

        try {
            StatisticsMibGraphModel statisgraphmodel =
                new StatisticsMibGraphModel();

            StatisticsMibProperty statisticsProp =
                statisgraphmodel.getList(
                    engineAddress, nodeIPAddress, oid.substring(
                        "oid=".length()), instance, startTime, endTime);

            // System.out.println("conv oid : " + oid.substring("oid=".length()));
            mibUnit = statisticsProp.getMibInstanceUnit();

            ArrayList list = statisticsProp.getMibInfoList();

            int arraysize = list.size();

            if (itemNum > arraysize) {
                resTime = new String[itemNum];
                resDate = new String[itemNum];
            } else {
                resTime = new String[arraysize];
                resDate = new String[arraysize];
            }

            StatisticsMibInfo statisGraphInfo = null;
            DateFormat graphDateformat =
                new SimpleDateFormat("yy-MM-dd HH:mm:ss");

            long nexttime = 0;
            double dateUnit = 0;

            for (dataCnt = 0; dataCnt < arraysize; dataCnt++) {
                if (dataCnt >= itemNum) {
                    /*
                     * ݎw肪ꍇɂ́Aw̍ő\ڐ𒴂Ă
                     * f[^Zbg
                     */
                    if (notchMode.equals("No")) {
                        break;
                    }
                }

                if (mode.equals("difference")) {
                    // f[^
                    if (arraysize < 2) {
                        break;
                    }

                    double nextdata;
                    long difftime = 0;
                    double diffdata = 0;

                    try {
                        if ((dataCnt + 1) < arraysize) {
                            nextdata =
                                Double.parseDouble(
                                    ((StatisticsMibInfo) list.get(dataCnt + 1))
                                    .getStatisMibValue());
                            nexttime =
                                ((StatisticsMibInfo) list.get(dataCnt + 1)).getDate()
                                 .getTime();

                            // System.out.println("nexttime0 : " + nexttime);
                        } else {
                            nextdata =
                                Double.parseDouble(
                                    ((StatisticsMibInfo) list.get(dataCnt))
                                    .getStatisMibValue());
                            nexttime =
                                ((StatisticsMibInfo) list.get(dataCnt)).getDate()
                                 .getTime();

                            // System.out.println("nexttime1 : " + nexttime);
                        }

                        /* System.out.println(
                            "nowtime : "
                            + ((StatisticsMibInfo) list.get(dataCnt)).getDate()
                               .getTime());
                        */
                        difftime =
                            ((StatisticsMibInfo) list.get(dataCnt)).getDate()
                             .getTime() - nexttime;

                        diffdata =
                            Double.parseDouble(
                                ((StatisticsMibInfo) list.get(dataCnt))
                                .getStatisMibValue()) - nextdata;

                        // System.out.println("difftime : " + difftime);
                        // System.out.println("diffdata : " + diffdata);
                    } catch (NumberFormatException ex) {
                        nextdata = 0;
                    }

                    try {
                        resTime[dataCnt] = Double.toString(diffdata);
                        dateUnit = difftime / 1000;
                    } catch (ArithmeticException ex) {
                        resTime[dataCnt] = "unknown";
                    }
                } else {
                    // ώZf[^
                    // System.out.println("arraysize : " + arraysize);
                    // System.out.println("datacnt : " + dataCnt);
                    if (arraysize < 1) {
                        break;
                    }

                    /* System.out.println(
                        "mib_value : "
                        + ((StatisticsMibInfo) list.get(dataCnt))
                        .getStatisMibValue());
                    */
                    resTime[dataCnt] =
                        ((StatisticsMibInfo) list.get(dataCnt))
                        .getStatisMibValue();
                }

                statisGraphInfo = (StatisticsMibInfo) list.get(dataCnt);
                resDate[dataCnt] =
                    graphDateformat.format(statisGraphInfo.getDate());
            }

            DateFormat propertyDateformat =
                new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

            String startDate = "";
            String endtDate = "";

            if (
                (statisticsProp != null)
                    && (statisticsProp.getStartDate() != null)) {
                startDate =
                    propertyDateformat.format(statisticsProp.getStartDate());
            }

            if (
                (statisticsProp != null)
                    && (statisticsProp.getEndDate() != null)) {
                endtDate =
                    propertyDateformat.format(statisticsProp.getEndDate());
            }

            NodeInformation nodeInfo = null;

            NodeRegisterModel noderegister = new NodeRegisterModel();
            nodeInfo = noderegister.getIPTarget(engineAddress, nodeIPAddress);
            response.setContentType("text/plain");

            PrintWriter out = response.getWriter();

            out.print("nodeName" + "=" + nodeInfo.getNodename());
            out.print(
                "&totalDataCount" + "=" + statisticsProp.getTotalDataCount());

            out.print("&mibUnit" + "=" + mibUnit);
            out.print("&dateUnit" + "=" + dateUnit);
            out.print("&startDate" + "=" + startDate);
            out.print("&endDate" + "=" + endtDate);
            out.print("&minData" + "=" + statisticsProp.getMinData());
            out.print("&maxData" + "=" + statisticsProp.getMaxData());

            int sendDataCount = 0;
            int notch = 1;

            if (notchMode.equals("No")) {
                notch = 1;
            } else if (notchMode.equals("Auto")) {
                /* f[^\݂𑍃f[^Zo */
                while ((dataCnt / notch) > 40) {
                    notch += 20;
                }
            } else {
                /* w̃f[^ݐZbg */
                try {
                    notch = Integer.parseInt(notchMode);
                } catch (NumberFormatException e) {
                    logger.warning(e.getMessage());
                }
            }

            if (mode.equals("difference")) {
                sendDataCount = (dataCnt - 1) / notch;
            } else {
                sendDataCount = (dataCnt) / notch;
            }

            out.print("&dataCNT" + "=" + sendDataCount);

            for (
                int count = 0, notchCount = 0; count < sendDataCount;
                    count++, notchCount++) {
                out.print("&dataOUT" + count + "=" + resTime[notchCount]);
                out.print("&dataDATE" + count + "=" + resDate[notchCount]);
                notchCount += (notch - 1);
            }
        } catch (Exception ex) {
            logger.warning(ex.getMessage());
            ex.printStackTrace();
        }
    }
}
