/*
 * Created on 2003/07/28
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.graph.flashaction;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.logging.Logger;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.socket.info.PingInfo;
import netjfwatcher.engine.socket.info.PingProperty;
import netjfwatcher.engine.socket.info.PingResponseInfo;
import netjfwatcher.graph.model.PingResModel;
import netjfwatcher.noderegister.model.NodeRegisterModel;
import netjfwatcher.preference.Preference;


/**
 * PingԃOt\pFlashNT[ubgNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class PingResAction extends HttpServlet {
    private static Logger logger;

    public void doPost(
        HttpServletRequest request, HttpServletResponse response)
        throws IOException, ServletException {
        logger = Logger.getLogger(this.getClass().getName());

        String engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);
        String ipaddress = request.getParameter(Preference.IPADDRESS);

        /*
         * wԓf[^x[XANZXpɕϊ
         */
        String startTime =
            request.getParameter(Preference.START_YY) + "-"
            + request.getParameter(Preference.START_MM) + "-"
            + request.getParameter(Preference.START_DD) + " "
            + request.getParameter(Preference.START_HH) + ":"
            + request.getParameter(Preference.START_MIN) + ":00.0";
        String endTime =
            request.getParameter(Preference.END_YY) + "-"
            + request.getParameter(Preference.END_MM) + "-"
            + request.getParameter(Preference.END_DD) + " "
            + request.getParameter(Preference.END_HH) + ":"
            + request.getParameter(Preference.END_MIN) + ":00.0";

        // System.out.println("starttime : " + startTime);
        // System.out.println("endtime : " + endTime);

        /* \ijf[^擾 */
        int itemNum =
            Integer.parseInt(
                request.getParameter(Preference.GRAPH_ITEM_NUMBER));

        /* f[^ */
        String notchMode = request.getParameter(Preference.GRAPH_NOTCH);
        NodeInformation nodeInfo = null;

        try {
            NodeRegisterModel noderegister = new NodeRegisterModel();
            nodeInfo = noderegister.getIPTarget(engineAddress, ipaddress);
        } catch (EngineConnectException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        } catch (IOException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        }

        int dataCnt;

        PingResponseInfo pingInfo = null;
        PingProperty pingProperty = null;

        ArrayList pingDataList = null;

        try {
            PingResModel pingResModel = new PingResModel();
            pingInfo =
                pingResModel.getPingDataList(
                    engineAddress, ipaddress, startTime, endTime);
            pingDataList = pingInfo.getPingDataList();
            pingProperty = pingInfo.getPingProperty();
        } catch (EngineConnectException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        } catch (IOException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }

        int arraysize = pingDataList.size();

        PingInfo pingres;

        DateFormat dateformat = new SimpleDateFormat("yy-MM-dd HH:mm:ss");

        String[] resTime = new String[arraysize];
        String[] resDate = new String[arraysize];

        for (dataCnt = 0; dataCnt < arraysize; dataCnt++) {
            pingres = (PingInfo) pingDataList.get(dataCnt);

            if (dataCnt >= itemNum) {
                /*
                * ݎw肪ꍇɂ́Aw̍ő\ڐ𒴂Ă
                * f[^Zbg
                */
                if (notchMode.equals("No")) {
                    break;
                }
            }

            resTime[dataCnt] = Long.toString(pingres.getPingDiffTime());
            resDate[dataCnt] = dateformat.format(pingres.getPingCheckDate());
        }

        dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        response.setContentType("text/plain");

        PrintWriter out = response.getWriter();
        out.print("nodeName" + "=" + nodeInfo.getNodename());
        out.print("&startDate" + "=" + (pingProperty.getStartDate()));
        out.print("&endDate" + "=" + (pingProperty.getEndDate()));
        out.print("&minData" + "=" + pingProperty.getMinData());
        out.print("&maxData" + "=" + pingProperty.getMaxData());

        long sendDataCount = 0;
        long notch = 1;

        if (notchMode.equals("No")) {
            notch = 1;
        } else if (notchMode.equals("Auto")) {
            while ((dataCnt / notch) > 40) {
                notch += 20;
            }
        } else {
            try {
                notch = Integer.parseInt(notchMode);
            } catch (NumberFormatException e) {
                logger.warning(e.getMessage());
            }
        }

        /*
         * Ping̈ꔭڂ̉l͊
         */
        out.print(
            "&totalDataCount" + "=" + (pingProperty.getTotalDataCount() - 1));
        sendDataCount = (dataCnt - 1) / notch;
        out.print("&dataCNT" + "=" + sendDataCount);

        // logger.info("&dataCNT" + "=" + sendDataCount);
        for (
            int count = 0, notchCount = 0; count < sendDataCount;
                count++, notchCount++) {
            out.print("&dataOUT" + count + "=" + resTime[notchCount]);
            out.print("&dataDATE" + count + "=" + resDate[notchCount]);

            notchCount += (notch - 1);
        }
    }
}
