/*
 * Created on 2003/08/25
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.graph.flashaction;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.logging.Logger;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.engine.socket.info.InterfaceData;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.graph.model.InterfaceGraphModel;
import netjfwatcher.noderegister.model.NodeRegisterModel;
import netjfwatcher.preference.Preference;


/**
 * m[hC^tF[X_Ot\FlashGetAm[h̃C^tF[XM
 * pPbgԂ܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class InterfaceGraphAction extends HttpServlet {
    private static Logger logger = null;

    public void doPost(
        HttpServletRequest request, HttpServletResponse response)
        throws IOException, ServletException {
        logger = Logger.getLogger(this.getClass().getName());

        String serverAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        String nodeIPAddress = request.getParameter(Preference.IPADDRESS);
        String mode = request.getParameter("mode");

        try {
            NodeInformation nodeInfo = null;

            NodeRegisterModel noderegister = new NodeRegisterModel();
            nodeInfo = noderegister.getIPTarget(serverAddress, nodeIPAddress);

            /* C^tF[Xo̓pPbg̍܂͐ώZf[^擾 */
            InterfaceGraphModel interfacegraphmodel = new InterfaceGraphModel();
            ArrayList list =
                interfacegraphmodel.getList(serverAddress, nodeIPAddress, mode);

            String[] ifnum = new String[list.size()];
            String[] ifdata = new String[list.size()];

            for (int i = 0; i < list.size(); i++) {
                ifnum[i] = ((InterfaceData) list.get(i)).getInstanceName();
                ifdata[i] = ((InterfaceData) list.get(i)).getInstanceValue();
            }

            response.setContentType("text/plain");

            PrintWriter out = response.getWriter();
            out.print("nodeName" + "=" + nodeInfo.getNodename());
            out.print("&dataCNT" + "=" + list.size());

            for (int j = 0; j < list.size(); j++) {
                out.print("&ifnum" + j + "=" + ifnum[j]);
                out.print("&ifdata" + j + "=" + ifdata[j]);
            }
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response)
        throws IOException, ServletException {
        logger = Logger.getLogger(this.getClass().getName());

        String serverAddress = request.getParameter(Preference.ENGINE_ADDRESS);
        String nodeIPAddress = request.getParameter(Preference.IPADDRESS);
        String mode = request.getParameter("mode");

        response.setContentType("text/plain");

        PrintWriter out = response.getWriter();

        try {
            InterfaceGraphModel interfacegraphmodel = new InterfaceGraphModel();

            ArrayList list =
                interfacegraphmodel.getList(serverAddress, nodeIPAddress, mode);

            String[] ifnum = new String[list.size()];
            String[] ifdata = new String[list.size()];

            for (int i = 0; i < list.size(); i++) {
                ifnum[i] = ((InterfaceData) list.get(i)).getInstanceName();
                ifdata[i] = ((InterfaceData) list.get(i)).getInstanceValue();
            }

            out.print("dataCNT" + "=" + list.size());

            // logger.info("cnt : " + list.size());
            for (int j = 0; j < list.size(); j++) {
                out.print("&ifnum" + j + "=" + ifnum[j]);
                out.print("&ifdata" + j + "=" + ifdata[j]);

                // logger.info("&ifnum" + j + "=" + ifnum[j]);
                // logger.info("&ifdata" + j + "=" + ifdata[j]);
            }
        } catch (Exception ex) {
            ex.printStackTrace();
            logger.warning(ex.getMessage());
        }
    }
}
