/*
 * Created on 2004/04/23
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.export;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.logging.Logger;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.NodeMapLinkInformation;
import netjfwatcher.export.model.NodeRegisterInfoExportModel;
import netjfwatcher.nodemanager.list.model.NodeListViewModel;
import netjfwatcher.nodemap.model.NodeMapLinkModel;

import org.w3c.dom.Document;


/**
 * m[hXMLt@CƂăNCAg֏o͂܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeRegisterInfoExportAction extends HttpServlet {

    private static Logger logger = null;

    public void doGet(HttpServletRequest request, HttpServletResponse response)
        throws IOException, ServletException {
        logger = Logger.getLogger(this.getClass().getName());

        String engineAddress = request.getParameter("engineAddress");

        if (engineAddress == null) {
            engineAddress = "all";
        }

        NodeListViewModel nodeListModel = new NodeListViewModel();

        ArrayList nodeInfoList = null;

        try {
            nodeInfoList = nodeListModel.getList(engineAddress, null, null);
        } catch (EngineConnectException e1) {
            logger.warning("EngineConnectException " + e1.getMessage());
            throw new IOException("EngineConnectException " + e1.getMessage());
        } catch (IOException e1) {
            logger.warning("IOException " + e1.getMessage());
            throw e1;
        }

        NodeMapLinkInformation nodeMapLinkInfo = null;
        NodeMapLinkModel nodemaplinkmodel = new NodeMapLinkModel();

        try {
            nodeMapLinkInfo =
                nodemaplinkmodel.getNodeMapLinkInfo(engineAddress, null, null);
        } catch (EngineConnectException e) {
            logger.warning("EngineConnectException " + e.getMessage());
            throw new IOException("EngineConnectException " + e.getMessage());
        } catch (IOException e) {
            logger.warning("IOException " + e.getMessage());
            throw e;
        }

        NodeRegisterInfoExportModel model = new NodeRegisterInfoExportModel();

        Document dom = model.createDocument(nodeInfoList, nodeMapLinkInfo);

        outputXML(response, dom);
    }


    public void doPost(
        HttpServletRequest request, HttpServletResponse response)
        throws IOException, ServletException {
    }


    private void outputXML(HttpServletResponse response, Document dom)
        throws IOException {
        javax.xml.transform.Transformer tf = null;

        try {
            // TransformerFactoryCX^X擾
            TransformerFactory tfc = TransformerFactory.newInstance();

            // XSLt@Ctranceformer擾
            // tf = tfc.newTransformer(new StreamSource("nodeinfo.xsl"));
            tf = tfc.newTransformer();
            tf.setOutputProperty(OutputKeys.INDENT, "yes");

            // o͂GR[fBOݒ
            tf.setOutputProperty("encoding", "Shift_JIS");
        } catch (TransformerConfigurationException e) {
            // IuWFNg\zŎs
            logger.warning(
                "TransformerConfigurationException " + e.getMessage());
            e.printStackTrace();
        } catch (IllegalArgumentException e) {
            // vpeBT|[gĂȂAOԂŏCĂȂ
            logger.warning("IllegalArgumentException " + e.getMessage());
            e.printStackTrace();
        } catch (TransformerFactoryConfigurationError e) {
            /* TransformerFactory̎gpłȂCX^X
             * łȂ */
            e.printStackTrace();
        }

        response.setContentType("text/plain");

        PrintWriter out = response.getWriter();

        try {
            tf.transform(new DOMSource(dom), new StreamResult(System.out));
            tf.transform(new DOMSource(dom), new StreamResult(out));
        } catch (TransformerException e) {
            // ϊɉ񕜕s\ȃG[
            logger.warning("TransformerException " + e.getMessage());
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
