/*
 * Created on 2004/05/21
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.export;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.logging.Logger;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.nodemanager.list.model.NodeListViewModel;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.NodeInformation;


/**
 * m[hĎCSV`ŏo͂NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeRegisterInfoCSVExportAction extends HttpServlet {
    /** m[h */
    public static final String NODE_NAME = "Node Name";

    /** m[hIPAhX */
    public static final String IP_ADDRESS = "IP Address";

    /** Ping */
    public static final String PING_PERIOD = "Ping Period";

    /** Ping臒l */
    public static final String PING_THRESHHOLD = "Ping Threshhold";

    /** SNMPo[W */
    public static final String SNMP_VERSION = "SNMP Version";

    /** SNMPĎx */
    public static final String SNMP_LEVEL = "SNMP Level";

    /** SNMP ReadR~jeB */
    public static final String SNMP_READ_COMMUNITY_NAME =
        "SNMP Read Community name";

    /** SNMP Read/WriteR~jeB */
    public static final String SNMP_WRITE_COMMUNITY_NAME =
        "SNMP Write Community name";

    /** SNMPĎ */
    public static final String SNMP_PERIOD = "SNMP Period";

    /** HTTPĎ */
    public static final String HTTP_PERIOD = "HTTP Period";

    /** HTTPĎURL */
    public static final String HTTP_URL = "HTTP URL";

    /** HTTPĎ^CAEgl */
    public static final String HTTP_TIMEOUT = "HTTP TIMEOUT";

    /** Pop3Ď */
    public static final String POP3_PERIOD = "POP3 Period";

    /** Pop3Ď[U */
    public static final String POP3_USER = "POP3 User";

    /** Pop3ĎpX[h */
    public static final String POP3_PASSWORD = "POP3 Password";

    /** Pop3Ď|[g */
    public static final String POP3_PORT = "POP3 Port";

    /** Pop3Ď^CAEgl */
    public static final String POP3_TIMEOUT = "POP3 Timeout";

    /** SMTPĎ */
    public static final String SMTP_PERIOD = "SMTP Period";

    /** SMTPĎ|[g */
    public static final String SMTP_PORT = "SMTP Port";

    /** SMTPĎ^CAEgl */
    public static final String SMTP_TIMEOUT = "SMTP Timeout";

    /** SMTPĎMAhX */
    public static final String SMTP_SENDADDRESS = "SMTP Send Address";

    /** SMTPĎ`FbNPop3zXg */
    public static final String SMTP_CHECK_POP3_HOST = "SMTP Check Pop3 Host";

    /** SMTPĎ`FbNPop3[U */
    public static final String SMTP_CHECK_POP3_USER = "SMTP Check Pop3 User";

    /** SMTPĎ`FbNPop3pX[h */
    public static final String SMTP_CHECK_POP3_PASSWORD =
        "SMTP Check Pop3 Password";

    /** SMTPĎ`FbNPop3|[g */
    public static final String SMTP_CHECK_POP3_PORT = "SMTP Check Pop3 Port";

    /** SMTPĎ`FbNPop3^CAEgl */
    public static final String SMTP_CHECK_POP3_TIMEOUT =
        "SMTP Check Pop3 Timeout";

    /**
     * CSVo͂ɂJ^Cgi[z
     */
    private static final String[] HEADER_ORDER =
    {
        NODE_NAME, IP_ADDRESS, PING_PERIOD, PING_THRESHHOLD, SNMP_PERIOD,
        SNMP_VERSION, SNMP_LEVEL, SNMP_READ_COMMUNITY_NAME,
        SNMP_WRITE_COMMUNITY_NAME, HTTP_PERIOD, HTTP_URL, HTTP_TIMEOUT,
        POP3_PERIOD, POP3_USER, POP3_PASSWORD, POP3_PORT, POP3_TIMEOUT,
        SMTP_PERIOD, SMTP_PORT, SMTP_TIMEOUT, SMTP_SENDADDRESS,
        SMTP_CHECK_POP3_HOST, SMTP_CHECK_POP3_USER, SMTP_CHECK_POP3_PASSWORD,
        SMTP_CHECK_POP3_PORT, SMTP_CHECK_POP3_TIMEOUT
    };

    /* MO */
    private static Logger logger = null;

    public void doGet(HttpServletRequest request, HttpServletResponse response)
        throws IOException, ServletException {
        logger = Logger.getLogger(this.getClass().getName());

        String engineAddress = request.getParameter("engineAddress");

        if (engineAddress == null) {
            engineAddress = "all";
        }

        response.setContentType("text/plain");

        PrintWriter out = response.getWriter();

        for (int i = 0; i < HEADER_ORDER.length; i++) {
            out.print(HEADER_ORDER[i] + ",");
        }

        // oo͌̉s
        out.println();

        NodeListViewModel nodeListModel = new NodeListViewModel();

        ArrayList nodeInfoList = null;

        try {
            nodeInfoList = nodeListModel.getList(engineAddress, null, null);
        } catch (EngineConnectException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
            out.print(e.getMessage());

            return;
        } catch (IOException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
            out.print(e.getMessage());

            return;
        }

        // System.out.println("list.size() : " + nodeInfoList.size());

        for (int i = 0; i < nodeInfoList.size(); i++) {
            NodeInformation nodeInf = (NodeInformation) nodeInfoList.get(i);
            out.print(nodeInf.getNodename() + ",");
            out.print(nodeInf.getIpaddress() + ",");
            out.print(nodeInf.getPingPeriod() + ",");
            out.print(nodeInf.getPingThreshold() + ",");
            out.print(nodeInf.getSnmpPeriod() + ",");
            out.print(nodeInf.getSnmpVersion() + ",");
            out.print(nodeInf.getSnmpLevel() + ",");
            out.print(nodeInf.getRoCommunity() + ",");
            out.print(nodeInf.getRwCommunity() + ",");
            out.print(nodeInf.getHttpPeriod() + ",");
            out.print(nodeInf.getHttpUrl() + ",");
            out.print(nodeInf.getHttpTimeout() + ",");
            out.print(nodeInf.getPopPeriod() + ",");
            out.print(nodeInf.getPopUser() + ",");
            out.print(nodeInf.getPopPassword() + ",");
            out.print(nodeInf.getPopPort() + ",");
            out.print(nodeInf.getPopTimeout() + ",");
            out.print(nodeInf.getSmtpPeriod() + ",");
            out.print(nodeInf.getSmtpPort() + ",");
            out.print(nodeInf.getSmtpTimeout() + ",");
            out.print(nodeInf.getSmtpSendAddress() + ",");
            out.print(nodeInf.getSmtpCheckHost() + ",");
            out.print(nodeInf.getSmtpCheckUser() + ",");
            out.print(nodeInf.getSmtpCheckPassword() + ",");
            out.print(nodeInf.getSmtpCheckPort() + ",");
            out.print(nodeInf.getSmtpCheckTimeout() + ",");
            out.println();
        }
    }
}
