/*
 * Created on 2004/05/14
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.socket.info;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

/**
 * \[XێNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ResourceInfo implements Serializable {
	/*
	 * serialVersionUID
	 */
	private static final long serialVersionUID = 5371937698439514154L;

	/* GW|[g */
	private String enginePort;

	/* GWڑzXg */
	private String engineAllowHost;

	/* f[^x[X */
	private String databaseName;

	/* f[^x[XhCo */
	private String databaseDriver;

	/* f[^x[XURL */
	private String databaseUrl;

	/* f[^x[X[U */
	private String databaseUser;

	/* f[^x[XpX[h */
	private String databasePassword;

	/* SNMPĎ|[g */
	private int snmpPort;

	/* SNMP Trap|[g */
	private int snmpTrapPort;

	/* SNMP V1^CAEgl */
	private String snmpV1Timeout;

	/* SNMP V2^CAEgl */
	private String snmpV2Timeout;

	/* SNMP V3^CAEgl */
	private String snmpV3Timeout;

	/* SNMP V1gCl */
	private String snmpV1Retry;

	/* SNMP V1gCl */
	private String snmpV2Retry;

	/* SNMP V2gCl */
	private String snmpV3Retry;

	/* SNMP V3\񃊃Xg */
	private ArrayList snmpV3ConfigList;

	/* AgentAhXL[ƂSNMP V3\Map */
	private HashMap snmpV3ConfigMapList;

	/* PingĎ^CAEgl */
	private String pingTimeout;

	/* PingĎgCl */
	private String pingRetry;

	/* XML Socket|[g */
	private String xmlSocketPort;

	/* AlertTEh */
	private String alertSound;

	/* XML SocketڑzXg */
	private String xmlSocketAllowHost;

	/* XML Socketڑő吔 */
	private String xmlSocketMaxConnect;

	/* uEUXV */
	private String refreshTime;

	/* MailMtB^[ G[x */
	private String mailFilterErrorLevel;

	/* MailMtB^[ `FbNtO */
	private boolean mailFilterStringFlag;

	/* MailMtB^[ `FbN */
	private String mailFilterString;

	/* MailMK[h */
	private String mailGuardTime;

	/* A[ێ */
	private String alarmHoldPeriodDay;

	/* A[őێ */
	private String alarmMax;

	/* vMIBێ */
	private String statisticsHoldPeriodDay;

	/* vMIBőێ */
	private String statisticsMax;

	/* MailvpeB񃊃Xg */
	private ArrayList mailPropertyList = new ArrayList();

	/**
	 * xpTEht@CԂ܂B
	 * 
	 * @return alertSound xpTEht@C
	 */
	public String getAlertSound() {
		return alertSound;
	}

	/**
	 * f[^x[XhCoԂ܂B
	 * 
	 * @return databaseDriver f[^x[XhCo
	 */
	public String getDatabaseDriver() {
		return databaseDriver;
	}

	/**
	 * f[^x[XԂ܂B
	 * 
	 * @return databaseName f[^x[X
	 */
	public String getDatabaseName() {
		return databaseName;
	}

	/**
	 * f[^x[XpX[hԂ܂B
	 * 
	 * @return databasePassword f[^x[XpX[h
	 */
	public String getDatabasePassword() {
		return databasePassword;
	}

	/**
	 * f[^x[XURLԂ܂B
	 * 
	 * @return databaseUrl f[^x[XURL
	 */
	public String getDatabaseUrl() {
		return databaseUrl;
	}

	/**
	 * f[^x[X[UԂ܂B
	 * 
	 * @return databaseUser f[^x[X[U
	 */
	public String getDatabaseUser() {
		return databaseUser;
	}

	/**
	 * GWڑ|[gԍԂ܂B
	 * 
	 * @return enginePort GWڑ|[gԍ
	 */
	public String getEnginePort() {
		return enginePort;
	}

	/**
	 * GWڑzXgԂ܂B
	 * 
	 * @return enginePort GWڑzXg
	 */
	public String getEngineAllowHost() {
		return engineAllowHost;
	}

	/**
	 * GWڑzXgZbg܂B
	 * 
	 * @param engineAllowHost
	 *            GWڑzXg
	 */
	public void setEngineAllowHost(String engineAllowHost) {
		this.engineAllowHost = engineAllowHost;
	}

	/**
	 * PinggC񐔂Ԃ܂B
	 * 
	 * @return pingRetry PinggC
	 */
	public String getPingRetry() {
		return pingRetry;
	}

	/**
	 * Ping^CAEglԂ܂B
	 * 
	 * @return pingTimeout Ping^CAEgl
	 */
	public String getPingTimeout() {
		return pingTimeout;
	}

	/**
	 * SNMP V1gC񐔂Ԃ܂B
	 * 
	 * @return snmpV1Retry SNMP V1gC
	 */
	public String getSnmpV1Retry() {
		return snmpV1Retry;
	}

	/**
	 * SNMP V2gC񐔂Ԃ܂B
	 * 
	 * @return snmpV2Retry SNMP V2gC
	 */
	public String getSnmpV2Retry() {
		return snmpV2Retry;
	}

	/**
	 * SNMP V3gC񐔂Ԃ܂B
	 * 
	 * @return snmpV3Retry SNMP V3gC
	 */
	public String getSnmpV3Retry() {
		return snmpV3Retry;
	}

	/**
	 * SNMP V1^CAEglԂ܂B
	 * 
	 * @return snmpV1Timeout SNMP V1^CAEgl
	 */
	public String getSnmpV1Timeout() {
		return snmpV1Timeout;
	}

	/**
	 * SNMP V2^CAEglԂ܂B
	 * 
	 * @return snmpV2Timeout SNMP V2^CAEgl
	 */
	public String getSnmpV2Timeout() {
		return snmpV2Timeout;
	}

	/**
	 * SNMP V3^CAEglԂ܂B
	 * 
	 * @return snmpV3Timeout SNMP V3^CAEgl
	 */
	public String getSnmpV3Timeout() {
		return snmpV3Timeout;
	}

	/**
	 * NCAgXMLSocketőڑԂ܂B
	 * 
	 * @return xmlSocketMaxConnect NCAgXMLSocketőڑ
	 */
	public String getXmlSocketMaxConnect() {
		return xmlSocketMaxConnect;
	}

	/**
	 * NCAgXMLSocketڑ|[gԍԂ܂B
	 * 
	 * @return xmlSocketPort NCAgXMLSocketڑ|[gԍ
	 */
	public String getXmlSocketPort() {
		return xmlSocketPort;
	}

	/**
	 * NCAgxTEhZbg܂B
	 * 
	 * @param string
	 *            NCAgxTEh
	 */
	public void setAlertSound(String string) {
		alertSound = string;
	}

	/**
	 * f[^x[XhCoZbg܂B
	 * 
	 * @param string
	 *            f[^x[XhCo
	 */
	public void setDatabaseDriver(String string) {
		databaseDriver = string;
	}

	/**
	 * f[^x[XZbg܂B
	 * 
	 * @param string
	 *            f[^x[X
	 */
	public void setDatabaseName(String string) {
		databaseName = string;
	}

	/**
	 * f[^x[XpX[hZbg܂B
	 * 
	 * @param string
	 *            f[^x[XpX[h
	 */
	public void setDatabasePassword(String string) {
		databasePassword = string;
	}

	/**
	 * f[^x[XURLZbg܂B
	 * 
	 * @param string
	 *            f[^x[XURL
	 */
	public void setDatabaseUrl(String string) {
		databaseUrl = string;
	}

	/**
	 * f[^x[X[UZbg܂B
	 * 
	 * @param string
	 *            f[^x[X[U
	 */
	public void setDatabaseUser(String string) {
		databaseUser = string;
	}

	/**
	 * GW̐ڑ|[gԍZbg܂B
	 * 
	 * @param string
	 *            GW̐ڑ|[gԍ
	 */
	public void setEnginePort(String string) {
		enginePort = string;
	}

	/**
	 * PinggC񐔂Zbg܂B
	 * 
	 * @param string
	 *            PinggC
	 */
	public void setPingRetry(String string) {
		pingRetry = string;
	}

	/**
	 * Ping^CAEglZbg܂B
	 * 
	 * @param string
	 *            Ping^CAEgl
	 */
	public void setPingTimeout(String string) {
		pingTimeout = string;
	}

	/**
	 * SNMP V1 gCZbg܂B
	 * 
	 * @param string
	 *            SNMP V1gC
	 */
	public void setSnmpV1Retry(String string) {
		snmpV1Retry = string;
	}

	/**
	 * SNMP V2 gCZbg܂B
	 * 
	 * @param string
	 *            SNMP V2gC
	 */
	public void setSnmpV2Retry(String string) {
		snmpV2Retry = string;
	}

	/**
	 * SNMP V3 gCZbg܂B
	 * 
	 * @param string
	 *            SNMP V3gC
	 */
	public void setSnmpV3Retry(String string) {
		snmpV3Retry = string;
	}

	/**
	 * SNMP V1^CAEglZbg܂B
	 * 
	 * @param string
	 *            SNMP V1^CAEgl
	 */
	public void setSnmpV1Timeout(String string) {
		snmpV1Timeout = string;
	}

	/**
	 * SNMP V2^CAEglZbg܂B
	 * 
	 * @param string
	 *            SNMP V2^CAEgl
	 */
	public void setSnmpV2Timeout(String string) {
		snmpV2Timeout = string;
	}

	/**
	 * SNMP V3^CAEglZbg܂B
	 * 
	 * @param string
	 *            SNMP V3^CAEgl
	 */
	public void setSnmpV3Timeout(String string) {
		snmpV3Timeout = string;
	}

	/**
	 * XMLSocketőڑZbg܂B
	 * 
	 * @param string
	 *            XMLSocketőڑ
	 */
	public void setXmlSocketMaxConnect(String string) {
		xmlSocketMaxConnect = string;
	}

	/**
	 * XMLSocketڑ|[gԍZbg܂B
	 * 
	 * @param string
	 *            XMLSocketڑ|[gԍ
	 */
	public void setXmlSocketPort(String string) {
		xmlSocketPort = string;
	}

	/**
	 * MailvpeBListԂ܂B
	 * 
	 * @return mailPropertyList MailvpeBList
	 */
	public ArrayList getMailPropertyArrayList() {
		return mailPropertyList;
	}

	/**
	 * MailvpeBListZbg܂B
	 * 
	 * @param list
	 *            MailvpeBList
	 */
	public void setMailPropertyArrayList(ArrayList list) {
		mailPropertyList = list;
	}

	/**
	 * A[MailMvpeBXgzԂ܂B
	 * 
	 * @return mailProp A[MailMvpeBXgz
	 */
	public MailProperty[] getMailPropertyList() {
		MailProperty[] mailProp = new MailProperty[mailPropertyList.size()];

		for (int i = 0; i < mailPropertyList.size(); i++) {
			mailProp[i] = (MailProperty) mailPropertyList.get(i);
		}

		return mailProp;
	}

	/**
	 * A[MailMvpeBXgɒǉ܂B
	 * 
	 * @param mailProperty
	 *            A[MailMvpeB
	 */
	public void setMailPropertyList(MailProperty mailProperty) {
		mailPropertyList.add(mailProperty);
	}

	/**
	 * A[MailMvpeBXgZbg܂B
	 * 
	 * @param mailProperty
	 *            A[MailMvpeBz
	 */
	public void setMailPropertyList(MailProperty[] mailProperty) {
		mailPropertyList.clear();

		for (int i = 0; i < mailProperty.length; i++) {
			mailPropertyList.add(mailProperty[i]);
		}
	}

	/**
	 * A[MailMK[h^ClԂ܂B
	 * 
	 * @return mailGuardTime A[MailMK[h^Cl
	 */
	public String getMailGuardTime() {
		return mailGuardTime;
	}

	/**
	 * A[MailMK[h^ClZbg܂B
	 * 
	 * @param string
	 *            A[MailMK[h^Cl
	 */
	public void setMailGuardTime(String string) {
		mailGuardTime = string;
	}

	/**
	 * A[őێԂ܂B
	 * 
	 * @return alarmMax A[őێ
	 */
	public String getAlarmMax() {
		return alarmMax;
	}

	/**
	 * A[ێԂԂ܂B
	 * 
	 * @return alarmHoldPeriodDay A[ێ
	 */
	public String getAlarmHoldPeriodDay() {
		return alarmHoldPeriodDay;
	}

	/**
	 * A[őێZbg܂B
	 * 
	 * @param string
	 *            A[őێ
	 */
	public void setAlarmMax(String string) {
		alarmMax = string;
	}

	/**
	 * A[ێԂZbg܂B
	 * 
	 * @param string
	 *            A[ێ
	 */
	public void setAlarmHoldPeriodDay(String string) {
		alarmHoldPeriodDay = string;
	}

	/**
	 * vMIBێԂԂ܂B
	 * 
	 * @return statisticsHoldPeriodDay vMIBێ
	 */
	public String getStatisticsHoldPeriodDay() {
		return statisticsHoldPeriodDay;
	}

	/**
	 * vMIBőێԂ܂B
	 * 
	 * @return statisticsMax vMIBőێ
	 */
	public String getStatisticsMax() {
		return statisticsMax;
	}

	/**
	 * vMIBێԂZbg܂B
	 * 
	 * @param string
	 *            vMIBێ
	 */
	public void setStatisticsHoldPeriodDay(String string) {
		statisticsHoldPeriodDay = string;
	}

	/**
	 * vMIBőێZbg܂B
	 * 
	 * @param string
	 *            vMIBőێ
	 */
	public void setStatisticsMax(String string) {
		statisticsMax = string;
	}

	/**
	 * tbV^C}[lԂ܂B
	 * 
	 * @return refreshTime tbV^C}[l
	 */
	public String getRefreshTime() {
		return refreshTime;
	}

	/**
	 * tbV^C}[lZbg܂B
	 * 
	 * @param string
	 *            tbV^C}[l
	 */
	public void setRefreshTime(String string) {
		refreshTime = string;
	}

	/**
	 * SNMP V3\`ListԂ܂B
	 * 
	 * @return snmpV3ConfigList SNMP V3\`List
	 */
	public ArrayList getSnmpV3ConfigList() {
		return snmpV3ConfigList;
	}

	/**
	 * SNMP V3\`ListZbg܂B
	 * 
	 * @param list
	 *            SNMP V3\`List
	 */
	public void setSnmpV3ConfigList(ArrayList list) {
		snmpV3ConfigList = list;
	}

	/**
	 * SNMP V3\`MapԂ܂B
	 * 
	 * @return snmpV3ConfigMapList SNMP V3\`Map
	 */
	public HashMap getSnmpV3ConfigMapList() {
		return snmpV3ConfigMapList;
	}

	/**
	 * SNMP V3\`MapZbg܂B
	 * 
	 * @param map
	 *            SNMP V3\`Map
	 */
	public void setSnmpV3ConfigMapList(HashMap map) {
		snmpV3ConfigMapList = map;
	}

	/**
	 * XML SocketڑzXgԂ܂B
	 * 
	 * @return xmlSocketAllowHost XML SocketڑzXg
	 */
	public String getXmlsocketAllowHost() {
		return xmlSocketAllowHost;
	}

	/**
	 * XML SocketڑzXgZbg܂B
	 * 
	 * @param string
	 *            XML SocketڑzXg
	 */
	public void setXmlsocketAllowHost(String string) {
		xmlSocketAllowHost = string;
	}

	/**
	 * SNMP|[gԍԂ܂B
	 * 
	 * @return snmpPort SNMP|[gԍ
	 */
	public int getSnmpPort() {
		return snmpPort;
	}

	/**
	 * SNMP Trap|[gԍԂ܂B
	 * 
	 * @return snmpTrapPort SNMP Trap|[gԍ
	 */
	public int getSnmpTrapPort() {
		return snmpTrapPort;
	}

	/**
	 * SNMP|[gԍZbg܂B
	 * 
	 * @param i
	 *            SNMP|[gԍ
	 */
	public void setSnmpPort(int i) {
		snmpPort = i;
	}

	/**
	 * SNMP Trap|[gԍZbg܂B
	 * 
	 * @param i
	 *            SNMP Trap|[gԍ
	 */
	public void setSnmpTrapPort(int i) {
		snmpTrapPort = i;
	}

	/**
	 * MailMtB^[ G[xԂ܂B
	 * 
	 * @return mailFilterErrorLevel MailMtB^[ G[x
	 */
	public String getMailFilterErrorLevel() {
		return mailFilterErrorLevel;
	}

	/**
	 * MailMtB^[ G[xZbg܂B
	 * 
	 * @param mailFilterErrorLevel
	 *            MailMtB^[ G[x
	 */
	public void setMailFilterErrorLevel(String mailFilterErrorLevel) {
		this.mailFilterErrorLevel = mailFilterErrorLevel;
	}

	/**
	 * MailMtB^[ `FbNԂ܂B
	 * 
	 * @return mailFilterString MailMtB^[ `FbN
	 */
	public String getMailFilterString() {
		return mailFilterString;
	}

	/**
	 * MailMtB^[ `FbNZbg܂B
	 * 
	 * @param mailFilterString
	 *            MailMtB^[`FbN
	 */
	public void setMailFilterString(String mailFilterString) {
		this.mailFilterString = mailFilterString;
	}

	/**
	 * MailMtB^[`FbNtOԂ܂B
	 * 
	 * @return mailFilterStringFlag MailMtB^[`FbNtO
	 */
	public boolean isMailFilterStringFlag() {
		return mailFilterStringFlag;
	}

	/**
	 * MailMtB^[`FbNtOZbg܂B
	 * 
	 * @param mailFilterStringFlag
	 *            MailMtB^[`FbNtO
	 */
	public void setMailFilterStringFlag(boolean mailFilterStringFlag) {
		this.mailFilterStringFlag = mailFilterStringFlag;
	}
}
