/*
 * Created on 2004/12/01
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.socket;

import java.io.IOException;

import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.command.control.CommandMappingTableResource;


/**
 * GWSNMPvMIB𑗎M郁\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ConnectionSnmpStatisricsInfo extends AbstractConnectionEngine {
    /**
     * GWSNMPvMIB𑗎M郁\bhNX
     * CX^X𐶐܂B
     *
     * @param engineAddress GWAhX
     *
     */
    public ConnectionSnmpStatisricsInfo(final String engineAddress) {
        super(engineAddress);
    }

    /**
     * wm[hSNMPvGW擾ĕԂ܂B
     *
     * @param nodeInfo m[hĎ
     * @return snmpStatisticsInfo SNMPvMIB
     * @throws EngineConnectException GWƂ̐ڑňُ킪ꍇ
     * @throws IOException GWƂ̐ڑňُ킪ꍇ
     */
    public String[] getSnmpStatisticsInfo(final NodeInformation nodeInfo)
        throws EngineConnectException, IOException {
        CommandInfo commnadInfo = new CommandInfo();
        commnadInfo.setNodeInformation(nodeInfo);
        commnadInfo.setCode(
            CommandMappingTableResource.SNMP_STATISTICS_INFO_COMMAND_ID);

        String[] snmpStatisticsInfo =
            (String[]) this.communicationToEngine(commnadInfo);

        return snmpStatisticsInfo;
    }
}
