/*
 * Created on 2004/07/07
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.socket;

import java.io.IOException;

import netjfwatcher.engine.socket.info.MibGetResponseList;
import netjfwatcher.engine.socket.info.MibInfo;
import netjfwatcher.engine.command.control.CommandMappingTableResource;
import netjfwatcher.snmp.preference.SnmpPreference;


/**
 * GWMIBZbg(Set Request)ʒmNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ConnectionMibSet extends AbstractConnectionEngine {
    /**
     * GWMIBZbgʒmNXCX^X𐶐܂B
     *
     * @param engineAddress GWAhX
     */
    public ConnectionMibSet(final String engineAddress) {
        super(engineAddress);
    }

    /**
     * GWMIBZbg(Set Request)ʒm܂B
     *
     * @param targetIPAddress m[hIPAhX
     * @param version SNMPo[W
     * @param community R~jeB
     * @param requestMibOid OID
     * @param oidSetValue Zbgl
     * @param valueType ZbgSNMP^Cv
     * @return responselist MIBZbg(Set Request)
     * @throws EngineConnectException GWƂ̐ڑňُ킪ꍇ
     * @throws IOException GWƂ̐ڑňُ킪ꍇ
     */
    public MibGetResponseList setMib(
        final String targetIPAddress, final String version,
        final String community, final String requestMibOid,
        final String oidSetValue, final String valueType)
        throws EngineConnectException, IOException {
        MibGetResponseList responselist = null;

        CommandInfo commandInfo = new CommandInfo();
        commandInfo.setCode(CommandMappingTableResource.MIBSET_COMMAND_ID);
        commandInfo.setIpaddress(targetIPAddress);

        MibInfo mibInfo = new MibInfo();

        if (version.equals("SNMPV1")) {
            mibInfo.setVersion(SnmpPreference.SNMP_VERSION_1);
        } else if (version.equals("SNMPV2C")) {
            mibInfo.setVersion(SnmpPreference.SNMPV2C);
        } else if (version.equals("SNMPV3")) {
            mibInfo.setVersion(SnmpPreference.SNMPV3);
        } else {
            mibInfo.setVersion(SnmpPreference.SNMP_VERSION_1);
        }

        mibInfo.setRwCommunity(community);
        mibInfo.setRequestMibOid(requestMibOid);
        mibInfo.setOidSetValue(oidSetValue);
        mibInfo.setOidType(valueType);
        commandInfo.setMibInfo(mibInfo);

        responselist =
            (MibGetResponseList) this.communicationToEngine(commandInfo);

        return responselist;
    }
}
