/*
 * Created on 2004/05/10
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.alarm.view;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.alarm.view.model.AlarmViewFilterModel;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.AlarmViewFilter;
import netjfwatcher.preference.Preference;


/**
 * A[tB^[ZbgHTTPT[ubgNXłB
 * A[tB^[ݒFlashN܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class AlarmViewFilterSet extends HttpServlet {
    /** A[tB^[ChJ[h */
    public static final String ANY = "*";

    /* MO */
    private static Logger logger;

    public void doPost(
        HttpServletRequest request, HttpServletResponse response)
        throws IOException, ServletException {
        logger = Logger.getLogger(this.getClass().getName());

        String mode = request.getParameter(Preference.ALARM_FILTER_MODE);

        String engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (engineAddress == null) {
            logger.warning("Not Engine Address");
            engineAddress = "all";
        }

        int filterStartYY = 0;
        int filterStartMM = 0;
        int filterStartDD = 0;
        int filterStartHH = 0;
        int filterStartMIN = 0;

        try {
            filterStartYY = Integer.parseInt(request.getParameter(Preference.ALARM_FILTER_START_YY));
            filterStartMM =
                Integer.parseInt(request.getParameter(Preference.ALARM_FILTER_START_MM)) - 1;
            filterStartDD = Integer.parseInt(request.getParameter(Preference.ALARM_FILTER_START_DD));
            filterStartHH = Integer.parseInt(request.getParameter(Preference.ALARM_FILTER_START_HH));
            filterStartMIN =
                Integer.parseInt(request.getParameter(Preference.ALARM_FILTER_START_MIN));
        } catch (NumberFormatException e3) {
            filterStartYY = 0;
            filterStartMM = 0;
            filterStartDD = 0;
            filterStartHH = 0;
            filterStartMIN = 0;
        }

        int filterEndYY = 0;
        int filterEndMM = 0;
        int filterEndDD = 0;
        int filterEndHH = 0;
        int filterEndMIN = 0;

        try {
            filterEndYY = Integer.parseInt(request.getParameter(Preference.ALARM_FILTER_END_YY));
            filterEndMM = Integer.parseInt(request.getParameter(Preference.ALARM_FILTER_END_MM)) - 1;
            filterEndDD = Integer.parseInt(request.getParameter(Preference.ALARM_FILTER_END_DD));
            filterEndHH = Integer.parseInt(request.getParameter(Preference.ALARM_FILTER_END_HH));
            filterEndMIN = Integer.parseInt(request.getParameter(Preference.ALARM_FILTER_END_MIN));
        } catch (NumberFormatException e2) {
            filterEndYY = 0;
            filterEndMM = 0;
            filterEndDD = 0;
            filterEndHH = 0;
            filterEndMIN = 0;
        }

        String filterConfirm = request.getParameter("confirm");
        String filterLevel = request.getParameter("level");
        String filterCode = request.getParameter("code");

        AlarmViewFilterModel alarmFilterMode = new AlarmViewFilterModel();

        AlarmViewFilter alarmViewFilter = null;
        ArrayList alarmFilterList = null;

        try {
            alarmFilterList = alarmFilterMode.getList(engineAddress);
        } catch (EngineConnectException e1) {
            logger.warning(e1.getMessage());
            throw new IOException(e1.getMessage());
        } catch (IOException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
            throw e1;
        }

        for (int i = 0; i < alarmFilterList.size(); i++) {
            alarmViewFilter = (AlarmViewFilter) alarmFilterList.get(i);
        }

        if (mode.equals("set")) {
            Calendar startcal = Calendar.getInstance();

            if (filterStartYY != 0) {
                startcal.set(
                    filterStartYY, filterStartMM, filterStartDD, filterStartHH,
                    filterStartMIN, 0);

                Date startdate = startcal.getTime();
                alarmViewFilter.setAlarmStartDate(
                    Long.toString(startdate.getTime()));
            } else {
                alarmViewFilter.setAlarmStartDate(ANY);
            }

            if (filterEndYY != 0) {
                startcal.set(
                    filterEndYY, filterEndMM, filterEndDD, filterEndHH,
                    filterEndMIN, 0);

                Date enddate = startcal.getTime();
                alarmViewFilter.setAlarmEndDate(
                    Long.toString(enddate.getTime()));
            } else {
                alarmViewFilter.setAlarmEndDate(ANY);
            }

            alarmViewFilter.setAlarmCode(filterCode);
            alarmViewFilter.setAlarmConfirm(filterConfirm);
            alarmViewFilter.setAlarmLevel(filterLevel);

            try {
                alarmFilterMode.setAlarmFilter(engineAddress, alarmViewFilter);
            } catch (EngineConnectException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
                throw new IOException(e.getMessage());
            } catch (IOException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
                throw e;
            }
        }

        response.setContentType("text/plain");

        PrintWriter out = response.getWriter();

        out.print("mode=" + mode);
        out.print("&nodename=" + alarmViewFilter.getNodename());
        out.print("&ipaddress=" + alarmViewFilter.getIpaddress());
        out.print("&confirm=" + alarmViewFilter.getAlarmConfirm());
        out.print("&code=" + alarmViewFilter.getAlarmCode());
        out.print("&level=" + alarmViewFilter.getAlarmLevel());
        out.print("&startdate=" + alarmViewFilter.getAlarmStartDate());
        out.print("&enddate=" + alarmViewFilter.getAlarmEndDate());

        /*
        System.out.println("&nodename=" + alarmViewFilter.getNodename());
        System.out.println("&ipaddress=" + alarmViewFilter.getIpaddress());
        System.out.println("&confirm=" + alarmViewFilter.getAlarmConfirm());
        System.out.println("&code=" + alarmViewFilter.getAlarmCode());
        System.out.println("&level=" + alarmViewFilter.getAlarmLevel());
        System.out.println("&startdate=" + alarmViewFilter.getAlarmStartDate());
        System.out.println("&enddate=" + alarmViewFilter.getAlarmEndDate());


        logger.info("mode : " + mode);
        logger.info("startdate : " + alarmViewFilter.getAlarmStartDate());
        */
    }
}
