/*
 * Created on 2003/07/31
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.alarm.view;

import java.net.InetAddress;
import java.util.ArrayList;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.alarm.view.model.AlarmViewModel;
import netjfwatcher.preference.Preference;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * A[Xg\ANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class AlarmViewAction extends Action {
    public ActionForward execute(
        ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception {
        String engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (engineAddress == null) {
            engineAddress = "all";
        }

        String ipaddress = request.getParameter(Preference.IPADDRESS);

        String sortColumn = null;

        if (
            (request.getParameter(Preference.SORT_COLUMN) != null)
                && !request.getParameter(Preference.SORT_COLUMN).equals("")) {
            sortColumn = request.getParameter(Preference.SORT_COLUMN);
        }

        String sortDirection = Preference.SORT_DIR_ASC;

        if (request.getParameter(Preference.SORT_DIRECTION) != null) {
            sortDirection = request.getParameter(Preference.SORT_DIRECTION);
        }

        AlarmViewModel alarmviewModel =
            new AlarmViewModel(ipaddress, sortColumn, sortDirection);

        String alarmIndiPage = "1";
        String alarmTotalPage = "1";

        if (request.getParameter(Preference.ALARM_TOTAL_PAGE) != null) {
            alarmTotalPage = request.getParameter(Preference.ALARM_TOTAL_PAGE);
        }

        int indiPage = 0;

        if (request.getParameter(Preference.ALARM_INDI_PAGE) != null) {
            alarmIndiPage = request.getParameter(Preference.ALARM_INDI_PAGE);
            indiPage =
                Integer.parseInt(
                    request.getParameter(Preference.ALARM_INDI_PAGE));
        }

        ArrayList alarmList =
            alarmviewModel.getAlarmList(
                engineAddress, 0,
                (indiPage - 1) * AlarmCountViewAction.ALARM_PAGE_LINE,
                indiPage * AlarmCountViewAction.ALARM_PAGE_LINE);

        if (sortDirection.equals(Preference.SORT_DIR_ASC)) {
            sortDirection = Preference.SORT_DIR_DESC;
        } else {
            sortDirection = Preference.SORT_DIR_ASC;
        }

        String alarmCount = "0";

        if (alarmList != null) {
            alarmCount = Integer.toString(alarmList.size());
        }

        request.setAttribute(Preference.ALARM_COUNT, alarmCount);
        request.setAttribute(Preference.ALARM_VIEW_LIST, alarmList);
        request.setAttribute(Preference.NODE_IPADDRESS, ipaddress);
        request.setAttribute(Preference.ALARM_INDI_PAGE, alarmIndiPage);
        request.setAttribute(Preference.ALARM_TOTAL_PAGE, alarmTotalPage);

        request.setAttribute(Preference.SORT_DIRECTION, sortDirection);

        String convIPAddress = ipaddress.replace('.', '_');

        request.setAttribute(Preference.CONV_IPADDRESS, convIPAddress);

        String servernamework1 =
            InetAddress.getLocalHost().toString().replace('.', '_');
        String servernamework2 = servernamework1.replace('/', '_');
        String frameNameforServername = servernamework2.replace('-', '_');

        request.setAttribute(
            Preference.FRAME_NAME_AT_SERVER_NAME, frameNameforServername);
        request.setAttribute(Preference.ENGINE_ADDRESS, engineAddress);

        return mapping.findForward(Preference.SUCCESS);
    }
}
