/*
 * Created on 2004/04/08
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.alarm.view;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.alarm.view.model.AlarmViewModel;
import netjfwatcher.preference.Preference;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * A[\ANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class AlarmCountViewAction extends Action {
    /** 1y[W̃A[ */
    public static final int ALARM_PAGE_LINE = 100;
    private static Logger logger;

    public ActionForward execute(
        ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception {
        logger = Logger.getLogger(this.getClass().getName());

        String engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (engineAddress == null) {
            logger.warning("Not Engine Address");
        }

        String ipaddress = request.getParameter(Preference.IPADDRESS);

        AlarmViewModel alarmviewModel =
            new AlarmViewModel(ipaddress, null, null);
        // System.out.println(ipaddress);

        ArrayList alarmList =
            alarmviewModel.getAlarmList(engineAddress, 0, 0, 0);

        String alarmCount = "0";
        String alarmTotalPage = "1";
        String alarmIndiPage = "1";

        if (request.getParameter(Preference.ALARM_INDI_PAGE) != null) {
            alarmIndiPage = request.getParameter(Preference.ALARM_INDI_PAGE);
        }

        if (alarmList != null) {
            alarmCount = Integer.toString(alarmList.size());

            int page = alarmList.size() / ALARM_PAGE_LINE;

            if ((page == 0) && (alarmList.size() >= ALARM_PAGE_LINE)) {
                page = 1;
            }

            if (
                ((alarmList.size() % ALARM_PAGE_LINE) > 0)
                    || (alarmList.size() == 0)) {
                page += 1;
            }

            alarmTotalPage = Integer.toString(page);
        }

        String sortColumn = "";

        if (request.getParameter(Preference.SORT_COLUMN) != null) {
            sortColumn = request.getParameter(Preference.SORT_COLUMN);
        }

        String sortDirection = Preference.SORT_DIR_DESC;

        if (request.getParameter(Preference.SORT_DIRECTION) != null) {
            sortDirection = request.getParameter(Preference.SORT_DIRECTION);
        }

        request.setAttribute(Preference.ALARM_INDI_PAGE, alarmIndiPage);
        request.setAttribute(Preference.ALARM_TOTAL_PAGE, alarmTotalPage);

        request.setAttribute(Preference.ALARM_COUNT, alarmCount);
        request.setAttribute(Preference.ALARM_VIEW_LIST, alarmList);
        request.setAttribute(Preference.NODE_IPADDRESS, ipaddress);
        request.setAttribute(Preference.SORT_COLUMN, sortColumn);
        request.setAttribute(Preference.SORT_DIRECTION, sortDirection);

        String servernamework1 =
            InetAddress.getLocalHost().toString().replace('.', '_');
        String servernamework2 = servernamework1.replace('/', '_');
        String frameNameforServername = servernamework2.replace('-', '_');
        String convIPAddress = ipaddress.replace('.', '_');

        request.setAttribute(Preference.CONV_IPADDRESS, convIPAddress);
        request.setAttribute(
            Preference.FRAME_NAME_AT_SERVER_NAME, frameNameforServername);
        request.setAttribute(Preference.ENGINE_ADDRESS, engineAddress);

        return mapping.findForward(Preference.SUCCESS);
    }
}
