/*
 * Created on 2006/08/17
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netWatcherRCPSound.timer;

import netWatcherRCPSound.alarmcheck.AlarmCheckThread;
import netWatcherRCPSound.alarmcheck.AlarmSoundFilter;
import netWatcherRCPSound.gui.SoundConfigEditorView;
import netWatcherRCPSound.jmfcontrol.JMFException;
import netWatcherRCPSound.jmfcontrol.JMFSoundControlThread;
import netWatcherRCPSound.jmfcontrol.SoundControlInfo;
import netjfwatcher.engine.alarm.AlarmCodeInformation;
import netjfwatcher.engine.alarm.AlarmMessageQueue;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/**
 * A[`FbNA[oɃTEh^C}[NXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class AlarmConfirmDialogTimerProcessor implements Runnable {
	private static final int TIMER = 1000;

	private static final int TIMER_STOP = -1;

	private int readPoint;

	private Shell shell;

	private Text mp3SoundPlayerStatusText;

	private Text alarmCheckStatusText;

	private Button alarmCheckStartButton;

	private Button alarmCheckStopButton;

	private AlarmConfirmDialogTimerProcessor() {
		// nothing
	}

	public void run() {

		if (!shell.isDisposed()) {
			if (mp3SoundPlayerStatusText != null
					&& !mp3SoundPlayerStatusText.isDisposed()) {
				if (SoundControlInfo.getInstance().isMp3Sound()) {
					if (JMFSoundControlThread.getInstance().checkThread()) {
						mp3SoundPlayerStatusText
								.setText(SoundConfigEditorView.ACTIVE);
					} else {
						mp3SoundPlayerStatusText
								.setText(SoundConfigEditorView.INACTIVE);
					}
				}
			}

			if (alarmCheckStatusText != null
					&& !alarmCheckStatusText.isDisposed()) {
				if (AlarmCheckThread.getInstance().checkThread()) {
					alarmCheckStatusText.setText(SoundConfigEditorView.ACTIVE);
					alarmCheckStartButton.setEnabled(false);
					alarmCheckStopButton.setEnabled(true);

				} else {
					alarmCheckStatusText
							.setText(SoundConfigEditorView.INACTIVE);
					alarmCheckStartButton.setEnabled(true);
					alarmCheckStopButton.setEnabled(false);
				}
			}
			if (AlarmCheckThread.getInstance().checkThread()) {
				checkAlarm();
			}

		}
	}

	public void startAlarmConfirmDialogTimerProcessor() {
		shell.getDisplay().timerExec(TIMER, this);
	}

	public void stopAlarmConfirmDialogTimerProcessor() {
		shell.getDisplay().timerExec(TIMER_STOP, this);
	}

	private void checkAlarm() {
		int writePoint = AlarmMessageQueue.getInstance().getWritePoint();

		if (readPoint != writePoint) {
			AlarmCodeInformation alarmInfo = (AlarmCodeInformation) AlarmMessageQueue
					.getInstance().popAlarmData(readPoint);

			if (alarmInfo != null) {

				if (AlarmSoundFilter.getInstance().checkAlarmLevelFilter(
						alarmInfo.getLevel())
						&& AlarmSoundFilter.getInstance().checkMessageFilter(
								alarmInfo.getMessage())) {

					String message;
					if (alarmInfo.getLevel() != null
							&& alarmInfo.getCode() != null) {
						message = "Node IP=" + alarmInfo.getIpaddress()
								+ " Level=" + alarmInfo.getLevel() + " Code="
								+ alarmInfo.getCode() + " Message="
								+ alarmInfo.getMessage() + ".    "
								+ "Alarm confirm and Continue watch alarm ?";
					} else {
						message = "Engine IP=" + alarmInfo.getEngineAddress()
								+ " Node IP=" + alarmInfo.getIpaddress()
								+ " Message=" + alarmInfo.getMessage()
								+ ".    "
								+ "Alarm confirm and Continue watch alarm ?";
					}
					if (!MessageDialog.openQuestion(shell, "Alarm detect",
							message)) {
						if (SoundControlInfo.getInstance().isMp3Sound()) {
							try {

								JMFSoundControlThread.getInstance()
										.stopSoundControlThread();
							} catch (JMFException e) {
								e.printStackTrace();
							}
						} else {
							SoundControlInfo.getInstance().setBeepSound(false);
						}

						// ^C}[~
						shell.getDisplay().timerExec(TIMER_STOP, this);
						BeepTimerProcessor.getInstance()
								.stopBeepTimerProcessor();
						alarmCheckStatusText
								.setText(SoundConfigEditorView.INACTIVE);
						alarmCheckStartButton.setEnabled(true);
						alarmCheckStopButton.setEnabled(false);
						return;
					}
					if (SoundControlInfo.getInstance().isMp3Sound()) {
						try {
							JMFSoundControlThread.getInstance()
									.stopSoundControlThread();
						} catch (JMFException e) {
							e.printStackTrace();
						}
					} else {
						SoundControlInfo.getInstance().setBeepSound(false);
					}
				}
			}

			readPoint++;

			if (readPoint >= AlarmMessageQueue.LIMIT) {
				readPoint = 0;
			}
		}
		// ^C}[p
		shell.getDisplay().timerExec(TIMER, this);
	}

	/**
	 * TimersShellZbg܂B
	 * 
	 * @param display
	 *            TimersShell
	 */
	public void setTimerConf(Shell shell) {
		this.shell = shell;
		readPoint = AlarmMessageQueue.getInstance().getWritePoint();
	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static AlarmConfirmDialogTimerProcessor getInstance() {
		return SingletonResource.RESOURCE;
	}

	public void setMp3SoundPlayerStatusText(Text alarmCheckStatusText,
			Text mp3SoundPlayerStatusText, Button alarmCheckStartButton,
			Button alarmCheckStopButton) {

		this.alarmCheckStatusText = alarmCheckStatusText;
		this.mp3SoundPlayerStatusText = mp3SoundPlayerStatusText;
		this.alarmCheckStartButton = alarmCheckStartButton;
		this.alarmCheckStopButton = alarmCheckStopButton;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final AlarmConfirmDialogTimerProcessor RESOURCE = new AlarmConfirmDialogTimerProcessor();
	}

	protected void finalize() throws java.lang.Throwable {
		if (shell != null && !shell.isDisposed()) {
			shell.getDisplay().timerExec(TIMER_STOP, this);
		}
		super.finalize();

	}
}
