/*
 * Created on 2006/08/17
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 *
 */
package netWatcherRCPSound.jmfcontrol;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.logging.Logger;

import javax.media.CannotRealizeException;
import javax.media.Controller;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.EndOfMediaEvent;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NoPlayerException;
import javax.media.Player;
import javax.media.StopAtTimeEvent;
import javax.media.Time;

import netWatcherRCPSound.alarmcheck.FilePreference;

/**
 * JMFTEhPlayeryPlay/Stop𐧌䂷ThreadNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class JMFSoundControlThread {

	private static Logger logger;

	private String mp3FileName = FilePreference.DEFAULT_MP3_FILE;

	private boolean isPlayer = false;

	private Player player;

	private JMFSoundControlThread() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	/**
	 * PlayerZbg܂B
	 * 
	 * @throws JMFException
	 *             PlayerɎsꍇ
	 */
	public void setPlayer() throws JMFException {
		if (!SoundControlInfo.getInstance().isMp3Sound()) {
			return;
		}
		try {
			player = Manager.createRealizedPlayer(new MediaLocator(new File(
					mp3FileName).toURL()));

			player.addControllerListener(new playerListener());

		} catch (NoPlayerException e) {
			logger.warning("NoPlayerException " + e.getMessage());
			throw new JMFException(e.getMessage());
		} catch (CannotRealizeException e) {
			logger.warning("CannotRealizeException " + e.getMessage());
			throw new JMFException(e.getMessage());
		} catch (MalformedURLException e) {
			logger.warning("MalformedURLException " + e.getMessage());
			throw new JMFException(e.getMessage());
		} catch (IOException e) {
			logger.warning("IOException " + e.getMessage());
			throw new JMFException(e.getMessage());
		} catch (Exception e) {
			logger.warning("Exception " + e.getMessage());
			throw new JMFException(e.getMessage());
		}
	}

	public boolean checkThread() {
		return isPlayer;
	}

	public void startSoundControlThread() throws JMFException {
		if (!SoundControlInfo.getInstance().isMp3Sound()) {

			return;
		}
		if (player == null) {
			setPlayer();
		}
		int state = player.getState();

		if (state != Controller.Started && state != Controller.Prefetching
				&& state != Controller.Prefetched) {
			player.setMediaTime(new Time(0));
			player.start();
		}
		isPlayer = true;
	}

	public void stopSoundControlThread() throws JMFException {
		if (!SoundControlInfo.getInstance().isMp3Sound()) {
			SoundControlInfo.getInstance().setBeepSound(false);
			return;
		}
		if (player == null) {
			return;
		}
		try {
			player.stop();
			player.deallocate();

		} catch (Exception e) {
			logger.warning("Exception " + e.getMessage());
			throw new JMFException(e.getMessage());
		} finally {
			isPlayer = false;
		}

	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static JMFSoundControlThread getInstance() {
		return SingletonResource.RESOURCE;
	}

	public String getMp3FileName() {
		return mp3FileName;
	}

	public void setMp3FileName(String mp3FileName) {
		this.mp3FileName = mp3FileName;
	}

	protected void finalize() throws Throwable {
		super.finalize();

		if (player != null) {
			player.stop();
			player.deallocate();
		}
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final JMFSoundControlThread RESOURCE = new JMFSoundControlThread();
	}

	private class playerListener implements ControllerListener {

		private final Time repeatTime = new Time(0);

		public playerListener() {

		}

		public synchronized void controllerUpdate(ControllerEvent event) {

			if (event instanceof EndOfMediaEvent) {
				player.setMediaTime(repeatTime);
				player.start();
			}

			if (event instanceof StopAtTimeEvent) {
				player.setMediaTime(repeatTime);
				player.start();

			}
		}
	}

}