/*
 * Created on 2006/08/17
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 *
 */
package netWatcherRCPSound.alarmcheck;

import java.util.logging.Logger;

import netWatcherRCPSound.jmfcontrol.JMFException;
import netWatcherRCPSound.jmfcontrol.JMFSoundControlThread;
import netWatcherRCPSound.jmfcontrol.SoundControlInfo;
import netjfwatcher.engine.alarm.AlarmCodeInformation;
import netjfwatcher.engine.alarm.AlarmMessageQueue;

/**
 * A[`FbNA[oɃTEhThreadNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class AlarmCheckThread implements Runnable {
	/* Thread sleep */
	private static final int WAIT_SLEEP_TIME = 1000;

	private static Logger logger;

	private Thread alarmCheckThread;

	private int readPoint = 0;

	private AlarmCheckThread() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	public boolean checkThread() {
		if ((alarmCheckThread == null) || !alarmCheckThread.isAlive()) {
			return false;
		}

		return true;
	}

	public boolean startAlarmCheckThread() throws JMFException {
		readPoint = AlarmMessageQueue.getInstance().getWritePoint();

		if ((alarmCheckThread == null) || !alarmCheckThread.isAlive()) {
			if (SoundControlInfo.getInstance().isMp3Sound()) {
				JMFSoundControlThread.getInstance().setPlayer();
			}
			alarmCheckThread = new Thread(this);

			if (alarmCheckThread != null) {
				alarmCheckThread.start();
			}

			return true;
		}

		return false;
	}

	public void stopAlarmCheckThread() {
		if (alarmCheckThread == null) {
			return;
		}

		// interrupt receive thread so it will die a natural death
		alarmCheckThread.interrupt();

		/* Thread~܂Loop */
		while ((alarmCheckThread != null) && alarmCheckThread.isAlive()) {
			try {
				Thread.sleep(WAIT_SLEEP_TIME);
			} catch (InterruptedException e) {
				logger.warning(e.getMessage());

				break;
			}
		}

		alarmCheckThread = null;
	}

	public void run() {
		while ((alarmCheckThread != null) && !alarmCheckThread.isInterrupted()) {
			try {
				int writePoint = AlarmMessageQueue.getInstance()
						.getWritePoint();

				// logger.info("readPoint : " + readPoint);
				// logger.info("writePoint : " + writePoint);
				if (readPoint != writePoint) {
					AlarmCodeInformation alarmInfo = (AlarmCodeInformation) AlarmMessageQueue
							.getInstance().popAlarmData(readPoint);

					if (alarmInfo != null) {
						if (!AlarmSoundFilter.getInstance()
								.checkAlarmLevelFilter(alarmInfo.getLevel())
								|| !AlarmSoundFilter.getInstance()
										.checkMessageFilter(
												alarmInfo.getMessage())) {
							continue;
						}

						if (SoundControlInfo.getInstance().isMp3Sound()) {
							if (!JMFSoundControlThread.getInstance()
									.checkThread()) {
								try {
									JMFSoundControlThread.getInstance()
											.startSoundControlThread();
								} catch (JMFException e) {
									logger.warning("JMFException : "
											+ e.getMessage());
								}
							}
						} else {
							SoundControlInfo.getInstance().setBeepSound(true);
						}
					}

					readPoint++;

					if (readPoint >= AlarmMessageQueue.LIMIT) {
						readPoint = 0;
					}
				}

				Thread.sleep(WAIT_SLEEP_TIME);
			} catch (InterruptedException e) {
				logger.warning(e.getMessage());

				break;
			}
		}
	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static AlarmCheckThread getInstance() {
		return SingletonResource.RESOURCE;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final AlarmCheckThread RESOURCE = new AlarmCheckThread();
	}
}
