/*
 * Decompiled with CFR 0.152.
 */
package netWatcherRCPSound.timer;

import netWatcherRCPSound.alarmcheck.AlarmCheckThread;
import netWatcherRCPSound.alarmcheck.AlarmSoundFilter;
import netWatcherRCPSound.jmfcontrol.JMFException;
import netWatcherRCPSound.jmfcontrol.JMFSoundControlThread;
import netWatcherRCPSound.jmfcontrol.SoundControlInfo;
import netWatcherRCPSound.timer.BeepTimerProcessor;
import netjfwatcher.engine.alarm.AlarmCodeInformation;
import netjfwatcher.engine.alarm.AlarmMessageQueue;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AlarmConfirmDialogTimerProcessor
implements Runnable {
    private static final int TIMER = 1000;
    private static final int TIMER_STOP = -1;
    private int readPoint;
    private Shell shell;
    private Text mp3SoundPlayerStatusText;
    private Text alarmCheckStatusText;
    private Button alarmCheckStartButton;
    private Button alarmCheckStopButton;

    private AlarmConfirmDialogTimerProcessor() {
    }

    public void run() {
        if (!this.shell.isDisposed()) {
            if (this.mp3SoundPlayerStatusText != null && !this.mp3SoundPlayerStatusText.isDisposed() && SoundControlInfo.getInstance().isMp3Sound()) {
                if (JMFSoundControlThread.getInstance().checkThread()) {
                    this.mp3SoundPlayerStatusText.setText("Active");
                } else {
                    this.mp3SoundPlayerStatusText.setText("Inactive");
                }
            }
            if (this.alarmCheckStatusText != null && !this.alarmCheckStatusText.isDisposed()) {
                if (AlarmCheckThread.getInstance().checkThread()) {
                    this.alarmCheckStatusText.setText("Active");
                    this.alarmCheckStartButton.setEnabled(false);
                    this.alarmCheckStopButton.setEnabled(true);
                } else {
                    this.alarmCheckStatusText.setText("Inactive");
                    this.alarmCheckStartButton.setEnabled(true);
                    this.alarmCheckStopButton.setEnabled(false);
                }
            }
            if (AlarmCheckThread.getInstance().checkThread()) {
                this.checkAlarm();
            }
        }
    }

    public void startAlarmConfirmDialogTimerProcessor() {
        this.shell.getDisplay().timerExec(1000, (Runnable)this);
    }

    public void stopAlarmConfirmDialogTimerProcessor() {
        this.shell.getDisplay().timerExec(-1, (Runnable)this);
    }

    private void checkAlarm() {
        int writePoint = AlarmMessageQueue.getInstance().getWritePoint();
        if (this.readPoint != writePoint) {
            AlarmCodeInformation alarmInfo = AlarmMessageQueue.getInstance().popAlarmData(this.readPoint);
            if (alarmInfo != null && AlarmSoundFilter.getInstance().checkAlarmLevelFilter(alarmInfo.getLevel()) && AlarmSoundFilter.getInstance().checkMessageFilter(alarmInfo.getMessage())) {
                String message = alarmInfo.getLevel() != null && alarmInfo.getCode() != null ? "Node IP=" + alarmInfo.getIpaddress() + " Level=" + alarmInfo.getLevel() + " Code=" + alarmInfo.getCode() + " Message=" + alarmInfo.getMessage() + ".    " + "Alarm confirm and Continue watch alarm ?" : "Engine IP=" + alarmInfo.getEngineAddress() + " Node IP=" + alarmInfo.getIpaddress() + " Message=" + alarmInfo.getMessage() + ".    " + "Alarm confirm and Continue watch alarm ?";
                if (!MessageDialog.openQuestion((Shell)this.shell, (String)"Alarm detect", (String)message)) {
                    if (SoundControlInfo.getInstance().isMp3Sound()) {
                        try {
                            JMFSoundControlThread.getInstance().stopSoundControlThread();
                        }
                        catch (JMFException e) {
                            e.printStackTrace();
                        }
                    } else {
                        SoundControlInfo.getInstance().setBeepSound(false);
                    }
                    this.shell.getDisplay().timerExec(-1, (Runnable)this);
                    BeepTimerProcessor.getInstance().stopBeepTimerProcessor();
                    this.alarmCheckStatusText.setText("Inactive");
                    this.alarmCheckStartButton.setEnabled(true);
                    this.alarmCheckStopButton.setEnabled(false);
                    return;
                }
                if (SoundControlInfo.getInstance().isMp3Sound()) {
                    try {
                        JMFSoundControlThread.getInstance().stopSoundControlThread();
                    }
                    catch (JMFException e) {
                        e.printStackTrace();
                    }
                } else {
                    SoundControlInfo.getInstance().setBeepSound(false);
                }
            }
            ++this.readPoint;
            if (this.readPoint >= 10) {
                this.readPoint = 0;
            }
        }
        this.shell.getDisplay().timerExec(1000, (Runnable)this);
    }

    public void setTimerConf(Shell shell) {
        this.shell = shell;
        this.readPoint = AlarmMessageQueue.getInstance().getWritePoint();
    }

    public static AlarmConfirmDialogTimerProcessor getInstance() {
        return SingletonResource.RESOURCE;
    }

    public void setMp3SoundPlayerStatusText(Text alarmCheckStatusText, Text mp3SoundPlayerStatusText, Button alarmCheckStartButton, Button alarmCheckStopButton) {
        this.alarmCheckStatusText = alarmCheckStatusText;
        this.mp3SoundPlayerStatusText = mp3SoundPlayerStatusText;
        this.alarmCheckStartButton = alarmCheckStartButton;
        this.alarmCheckStopButton = alarmCheckStopButton;
    }

    protected void finalize() throws Throwable {
        if (this.shell != null && !this.shell.isDisposed()) {
            this.shell.getDisplay().timerExec(-1, (Runnable)this);
        }
        super.finalize();
    }

    /* synthetic */ AlarmConfirmDialogTimerProcessor(AlarmConfirmDialogTimerProcessor alarmConfirmDialogTimerProcessor) {
        this();
    }

    private static class SingletonResource {
        static final AlarmConfirmDialogTimerProcessor RESOURCE = new AlarmConfirmDialogTimerProcessor(null);

        private SingletonResource() {
        }
    }
}

