/*
 * Decompiled with CFR 0.152.
 */
package netWatcherRCPSound.jmfcontrol;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.logging.Logger;
import javax.media.CannotRealizeException;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.EndOfMediaEvent;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NoPlayerException;
import javax.media.Player;
import javax.media.StopAtTimeEvent;
import javax.media.Time;
import netWatcherRCPSound.jmfcontrol.JMFException;
import netWatcherRCPSound.jmfcontrol.SoundControlInfo;

public final class JMFSoundControlThread {
    private static Logger logger;
    private String mp3FileName = "./plugins/netjfwatcher_alarm_mp3sound_1.0.0/sound/event_Female.mp3";
    private boolean isPlayer = false;
    private Player player;

    private JMFSoundControlThread() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void setPlayer() throws JMFException {
        if (!SoundControlInfo.getInstance().isMp3Sound()) {
            return;
        }
        try {
            this.player = Manager.createRealizedPlayer((MediaLocator)new MediaLocator(new File(this.mp3FileName).toURL()));
            this.player.addControllerListener((ControllerListener)new playerListener());
        }
        catch (NoPlayerException e) {
            logger.warning("NoPlayerException " + e.getMessage());
            throw new JMFException(e.getMessage());
        }
        catch (CannotRealizeException e) {
            logger.warning("CannotRealizeException " + e.getMessage());
            throw new JMFException(e.getMessage());
        }
        catch (MalformedURLException e) {
            logger.warning("MalformedURLException " + e.getMessage());
            throw new JMFException(e.getMessage());
        }
        catch (IOException e) {
            logger.warning("IOException " + e.getMessage());
            throw new JMFException(e.getMessage());
        }
        catch (Exception e) {
            logger.warning("Exception " + e.getMessage());
            throw new JMFException(e.getMessage());
        }
    }

    public boolean checkThread() {
        return this.isPlayer;
    }

    public void startSoundControlThread() throws JMFException {
        int state;
        if (!SoundControlInfo.getInstance().isMp3Sound()) {
            return;
        }
        if (this.player == null) {
            this.setPlayer();
        }
        if ((state = this.player.getState()) != 600 && state != 400 && state != 500) {
            this.player.setMediaTime(new Time(0L));
            this.player.start();
        }
        this.isPlayer = true;
    }

    public void stopSoundControlThread() throws JMFException {
        if (!SoundControlInfo.getInstance().isMp3Sound()) {
            SoundControlInfo.getInstance().setBeepSound(false);
            return;
        }
        if (this.player == null) {
            return;
        }
        try {
            try {
                this.player.stop();
                this.player.deallocate();
            }
            catch (Exception e) {
                logger.warning("Exception " + e.getMessage());
                throw new JMFException(e.getMessage());
            }
        }
        finally {
            this.isPlayer = false;
        }
    }

    public static JMFSoundControlThread getInstance() {
        return SingletonResource.RESOURCE;
    }

    public String getMp3FileName() {
        return this.mp3FileName;
    }

    public void setMp3FileName(String mp3FileName) {
        this.mp3FileName = mp3FileName;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.player != null) {
            this.player.stop();
            this.player.deallocate();
        }
    }

    /* synthetic */ JMFSoundControlThread(JMFSoundControlThread jMFSoundControlThread) {
        this();
    }

    private static class SingletonResource {
        static final JMFSoundControlThread RESOURCE = new JMFSoundControlThread(null);

        private SingletonResource() {
        }
    }

    private class playerListener
    implements ControllerListener {
        private final Time repeatTime = new Time(0L);

        public synchronized void controllerUpdate(ControllerEvent event) {
            if (event instanceof EndOfMediaEvent) {
                JMFSoundControlThread.this.player.setMediaTime(this.repeatTime);
                JMFSoundControlThread.this.player.start();
            }
            if (event instanceof StopAtTimeEvent) {
                JMFSoundControlThread.this.player.setMediaTime(this.repeatTime);
                JMFSoundControlThread.this.player.start();
            }
        }
    }
}

