/*
 * The MIT License
 *
 * Copyright 2015 nazo.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package jp.sourceforge.mmd.midiMotion.midi;
import javax.sound.midi.MidiEvent;
import java.util.Comparator;
import javax.sound.midi.ShortMessage;

/**
 * 全部 ShortMessage で同じチャンネルであることを想定しているので,
 * 実質MidiResolver 専用.
 * @author nazo
 */
public class MidiComparator implements Comparator<MidiEvent>{

    @Override
    public int compare(MidiEvent o1, MidiEvent o2) {
        int ret=(int)(o1.getTick()-o2.getTick());
        if(ret!=0) return ret;
        ShortMessage m1=(ShortMessage)o1.getMessage();
        ShortMessage m2=(ShortMessage)o2.getMessage();
        ret=m1.getCommand()-m2.getCommand();
        if(ret!=0) return ret;
        ret=m1.getData1()-m2.getData1();
        if(ret!=0) return ret;
        ret=m1.getData2()-m2.getData2();
        return ret;
    }
}
