/*
 * The MIT License
 *
 * Copyright 2015 nazo.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package jp.sourceforge.mmd.midiMotion.gui;

import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jp.sourceforge.mmd.midiMotion.midi.MidiResolver;

/**
 * {@link MidiMotionFrame} のタブになる {@link JPanel} クラス.
 * setName(String) で名前を付けること推奨
 * @author nazo
 */
abstract public class MotionPane extends JPanel {
    protected MidiResolver midiR;

    /**
     * 必ずタイトル(setName)をつける.
     * @param title タイトル
     */
    public MotionPane(String title) {
        setName(title);
    }

    /**
     * {@link MidiMotionFrame} から呼ばれるもの.
     * @param midiR midi 信号をあたえる resolver.
     */
    public void setMidiResolver(MidiResolver midiR) {
        this.midiR = midiR;
    }

    /**
     * MMD での frame per second を設定する.
     * {@link jp.sourceforge.mmd.midiMotion.MotionBuilder#setFPS(float)}を
     * 設定するものと想定されている.
     * @param fps MMD 出力先の frame per second
     */
    abstract public void setFPS(float fps);

    /**
     * エラーダイアログ
     * @param title タイトル
     * @param s メッセージ 
     */
    protected void log(String title,String s){
        JOptionPane.showMessageDialog(this, s, title,JOptionPane.WARNING_MESSAGE);
    }
}
