/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package jp.sourceforge.mmd.midiMotion.gui;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

/**
 *
 * @author nazo
 */
public class FileTransferable implements Transferable {
    private File contents;
    private static DataFlavor [] DataFlavorArray=new DataFlavor[]{
        DataFlavor.javaFileListFlavor,
        DataFlavor.stringFlavor
    };

    public FileTransferable(File f){
        contents=f;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return DataFlavorArray;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        if(!(flavor.isFlavorJavaFileListType()|| flavor.isFlavorTextType() )){
            System.err.println(flavor.getMimeType());
            return false;
        }
        return true;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if(flavor == DataFlavor.stringFlavor){
            return contents.getCanonicalPath();
        }else if(flavor == DataFlavor.javaFileListFlavor){
            ArrayList<File> a=new ArrayList<File>(1);
            a.add(contents);
            return a;
        }else {
            System.err.println("getTrans: "+flavor.getMimeType());
            throw new UnsupportedFlavorException(flavor);
        }
    }

}
