/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmd.motion.swing;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import jp.sfjp.mikutoga.bin.parser.MmdFormatException;
import jp.sourceforge.mmd.motion.Motion;
import jp.sourceforge.mmd.motion.model.Model;

public class MmdDialog {
    private static File modelDir;
    private static File motionDir;
    public static final String prefix = "MMDMotion.";
    public static File lastSelected;

    public static void loadDefault() {
        String s = System.getProperty("MMDMotion.motionDir");
        if (s == null) {
            s = ".";
        }
        motionDir = new File(s);
        s = System.getProperty("MMDMotion.modelDir");
        if (s == null) {
            s = ".";
        }
        modelDir = new File(s);
    }

    public static void saveDefault() {
        try {
            System.setProperty("MMDMotion.modelDir", modelDir.getCanonicalPath());
            System.setProperty("MMDMotion.motionDir", motionDir.getCanonicalPath());
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(null, "IO\u30a8\u30e9\u30fc:dir \u306e\u6b63\u5247\u540d\u304c\u5f97\u3089\u308c\u307e\u305b\u3093\u3002\n" + ex.getLocalizedMessage());
        }
    }

    public static Model loadModel(Component parent) {
        File f;
        Model ret = null;
        JFileChooser jfc = new JFileChooser(modelDir);
        jfc.setDialogTitle("\u30e2\u30c7\u30eb\u3092\u958b\u304f");
        jfc.setFileFilter(new FileNameExtensionFilter("MMD Model PMD, PMX", "pmd", "pmx"));
        jfc.addChoosableFileFilter(new FileNameExtensionFilter("MMD Model PMD", "pmd"));
        jfc.addChoosableFileFilter(new FileNameExtensionFilter("MMD Model PMX", "pmx"));
        jfc.addChoosableFileFilter(new FileNameExtensionFilter("MMD Model CSV", "csv", "csv.gz"));
        if (jfc.showOpenDialog(parent) != 0) {
            return null;
        }
        lastSelected = f = jfc.getSelectedFile();
        modelDir = f.getParentFile();
        String name = f.getName().toLowerCase();
        FileInputStream fis = null;
        try {
            if (name.endsWith(".pmd")) {
                fis = new FileInputStream(f);
                ret = Model.fromPMD(fis);
                fis.close();
            } else if (name.endsWith(".pmx")) {
                fis = new FileInputStream(f);
                ret = Model.fromPMX(fis);
                fis.close();
            } else if (name.endsWith(".csv.gz")) {
                fis = new FileInputStream(f);
                ret = Model.fromCSV(new GZIPInputStream(fis));
                fis.close();
            } else if (name.endsWith(".csv")) {
                fis = new FileInputStream(f);
                ret = Model.fromCSV(fis);
                fis.close();
            }
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(parent, "\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\n" + ex.getLocalizedMessage());
        }
        catch (ZipException ex) {
            JOptionPane.showMessageDialog(parent, "gzip\u5727\u7e2e\u304c\u304a\u304b\u3057\u3044\u3067\u3059\n" + ex.getLocalizedMessage());
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(parent, "IO\u30a8\u30e9\u30fc:\u8aad\u307f\u53d6\u308a\u306e\u5931\u6557\u306a\u3069\n" + ex.getLocalizedMessage());
        }
        catch (MmdFormatException ex) {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException ex1) {
                JOptionPane.showMessageDialog(parent, "IO\u30a8\u30e9\u30fc:\u8aad\u307f\u53d6\u308a\u306e\u5931\u6557\u306a\u3069\n" + ex.getLocalizedMessage());
            }
            JOptionPane.showMessageDialog(parent, "MMD\u30e2\u30c7\u30eb\u3068\u3057\u3066\u7570\u5e38\u3067\u3059\n" + ex.getLocalizedMessage());
        }
        return ret;
    }

    public static Motion loadMotion(Component parent) {
        File f;
        Motion ret = null;
        JFileChooser jfc = new JFileChooser(motionDir);
        jfc.setDialogTitle("\u30e2\u30fc\u30b7\u30e7\u30f3\u3092\u958b\u304f");
        jfc.setFileFilter(new FileNameExtensionFilter("MMD Motion VMD", "vmd"));
        jfc.addChoosableFileFilter(new FileNameExtensionFilter("MMD Motion CSV", "csv", "csv.gz"));
        if (jfc.showOpenDialog(parent) != 0) {
            return null;
        }
        lastSelected = f = jfc.getSelectedFile();
        motionDir = f.getParentFile();
        String name = f.getName().toLowerCase();
        FileInputStream fis = null;
        try {
            if (name.endsWith(".vmd")) {
                ret = new Motion();
                fis = new FileInputStream(f);
                ret.fromVMD(fis);
                fis.close();
            } else if (name.endsWith(".csv.gz")) {
                ret = new Motion();
                fis = new FileInputStream(f);
                ret.fromCSV(new GZIPInputStream(fis));
                fis.close();
            } else if (name.endsWith(".csv")) {
                ret = new Motion();
                fis = new FileInputStream(f);
                ret.fromCSV(fis);
                fis.close();
            }
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(parent, "\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\n" + ex.getLocalizedMessage());
        }
        catch (ZipException ex) {
            JOptionPane.showMessageDialog(parent, "gzip\u5727\u7e2e\u304c\u304a\u304b\u3057\u3044\u3067\u3059\n" + ex.getLocalizedMessage());
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(parent, "IO\u30a8\u30e9\u30fc:\u8aad\u307f\u53d6\u308a\u306e\u5931\u6557\u306a\u3069\n" + ex.getLocalizedMessage());
        }
        catch (MmdFormatException ex) {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException ex1) {
                JOptionPane.showMessageDialog(parent, "IO\u30a8\u30e9\u30fc:\u8aad\u307f\u53d6\u308a\u306e\u5931\u6557\u306a\u3069\n" + ex.getLocalizedMessage());
            }
            JOptionPane.showMessageDialog(parent, "MMD\u30e2\u30fc\u30b7\u30e7\u30f3\u3068\u3057\u3066\u3001\u7570\u5e38\u3067\u3059\n" + ex.getLocalizedMessage());
        }
        return ret;
    }
}

