/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.typical;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import jp.sfjp.mikutoga.pmd.MorphType;
import jp.sfjp.mikutoga.typical.AliasMap;
import jp.sfjp.mikutoga.typical.I18nAlias;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class TypicalMorph
extends I18nAlias {
    private static final Class<?> THISCLASS;
    private static final String MORPH_XML = "resources/typicalMorph.xml";
    private static final String ELEM_MORPHGROUP = "morphGroup";
    private static final String ELEM_MORPH = "morph";
    private static final String ATTR_TYPE = "type";
    private static final String ELEM_PRIMARY = "primary";
    private static final String ELEM_GLOBAL = "global";
    private static final String ATTR_NAME = "name";
    private static final List<TypicalMorph> EMPTY;
    private static final Map<MorphType, List<TypicalMorph>> TYPED_MAP;
    private static final AliasMap<TypicalMorph> MORPH_ALIAS_MAP;
    private final MorphType type;

    private TypicalMorph(MorphType type, int primaryNum, int globalNum) {
        super(primaryNum, globalNum);
        this.type = type;
        assert (this.getClass() == THISCLASS);
    }

    private static void parse(Element top) {
        NodeList groupList = top.getElementsByTagName(ELEM_MORPHGROUP);
        int groupNo = groupList.getLength();
        for (int idx = 0; idx < groupNo; ++idx) {
            Element groupElem = (Element)groupList.item(idx);
            TypicalMorph.parseGroup(groupElem);
        }
        for (MorphType morphType : MorphType.values()) {
            if (TYPED_MAP.containsKey((Object)morphType)) continue;
            TYPED_MAP.put(morphType, EMPTY);
        }
    }

    private static void parseGroup(Element groupElem) {
        String typeAttr = groupElem.getAttribute(ATTR_TYPE);
        MorphType morphType = MorphType.valueOf(typeAttr);
        NodeList morphList = groupElem.getElementsByTagName(ELEM_MORPH);
        int morphNo = morphList.getLength();
        List<TypicalMorph> groupedList = new ArrayList(morphNo);
        for (int idx = 0; idx < morphNo; ++idx) {
            Element morphElem = (Element)morphList.item(idx);
            TypicalMorph morph = TypicalMorph.parseMorph(morphElem, morphType);
            groupedList.add(morph);
            MORPH_ALIAS_MAP.addAlias(morph);
        }
        groupedList = Collections.unmodifiableList(groupedList);
        TYPED_MAP.put(morphType, groupedList);
    }

    private static TypicalMorph parseMorph(Element morphElem, MorphType mtype) {
        int idx;
        NodeList primaryNodes = morphElem.getElementsByTagName(ELEM_PRIMARY);
        NodeList globalNodes = morphElem.getElementsByTagName(ELEM_GLOBAL);
        int primaryNo = primaryNodes.getLength();
        int globalNo = globalNodes.getLength();
        assert (primaryNo > 0);
        TypicalMorph morph = new TypicalMorph(mtype, primaryNo, globalNo);
        for (idx = 0; idx < primaryNo; ++idx) {
            Element primaryElem = (Element)primaryNodes.item(idx);
            String primaryName = primaryElem.getAttribute(ATTR_NAME);
            morph.addPrimaryName(primaryName);
        }
        for (idx = 0; idx < globalNo; ++idx) {
            Element globalElem = (Element)globalNodes.item(idx);
            String globalName = globalElem.getAttribute(ATTR_NAME);
            morph.addGlobalName(globalName);
        }
        return morph;
    }

    private static void numbering() {
        int order = 0;
        for (MorphType morphType : MorphType.values()) {
            for (TypicalMorph morph : TYPED_MAP.get((Object)morphType)) {
                morph.setOrderNo(order++);
            }
        }
    }

    public static List<TypicalMorph> getTypicalMorphList(MorphType morphType) {
        List<TypicalMorph> result = TYPED_MAP.get((Object)morphType);
        return result;
    }

    public static TypicalMorph findWithPrimary(String primaryName) {
        TypicalMorph result = MORPH_ALIAS_MAP.getAliasByPrimary(primaryName);
        return result;
    }

    public static TypicalMorph findWithGlobal(String globalName) {
        TypicalMorph result = MORPH_ALIAS_MAP.getAliasByGlobal(globalName);
        return result;
    }

    public static String primary2global(String primaryName) {
        String globalName = MORPH_ALIAS_MAP.primary2global(primaryName);
        return globalName;
    }

    public static String global2primary(String globalName) {
        String primaryName = MORPH_ALIAS_MAP.global2primary(globalName);
        return primaryName;
    }

    public MorphType getMorphType() {
        return this.type;
    }

    static {
        Element top;
        THISCLASS = TypicalMorph.class;
        EMPTY = Collections.emptyList();
        TYPED_MAP = new EnumMap<MorphType, List<TypicalMorph>>(MorphType.class);
        MORPH_ALIAS_MAP = new AliasMap();
        InputStream is = THISCLASS.getResourceAsStream(MORPH_XML);
        try {
            top = I18nAlias.loadXml(is);
        }
        catch (ParserConfigurationException e) {
            throw new ExceptionInInitializerError(e);
        }
        catch (SAXException e) {
            throw new ExceptionInInitializerError(e);
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
        TypicalMorph.parse(top);
        TypicalMorph.numbering();
    }
}

