/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.bin.export;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import jp.sfjp.mikutoga.bin.export.IllegalTextExportException;
import jp.sfjp.mikutoga.bin.export.TextExporter;

public class BinaryExporter
implements Closeable,
Flushable {
    private static final Charset CS_UTF16LE = Charset.forName("UTF-16LE");
    private static final Charset CS_WIN31J = Charset.forName("windows-31j");
    private static final String ERRMSG_ILLENC = "illegal encoding";
    private static final String ERRMSG_TOOLONGTX = "too long text: text \"{0}\" needs {1}bytes encoded but limit={2}bytes";
    private static final int BYTES_SHORT = 2;
    private static final int BYTES_INT = 4;
    private static final int BYTES_LONG = 8;
    private static final int BYTES_FLOAT = 4;
    private static final int BYTES_DOUBLE = 8;
    private static final int BUFSZ_PRIM = 8;
    private static final int IDX0 = 0;
    private static final int IDX1 = 1;
    private static final int IDX2 = 2;
    private static final int IDX3 = 3;
    private static final int IDX4 = 4;
    private static final int IDX5 = 5;
    private static final int IDX6 = 6;
    private static final int IDX7 = 7;
    private static final int SH00 = 0;
    private static final int SH08 = 8;
    private static final int SH16 = 16;
    private static final int SH24 = 24;
    private static final int SH32 = 32;
    private static final int SH40 = 40;
    private static final int SH48 = 48;
    private static final int SH56 = 56;
    private final OutputStream ostream;
    private final byte[] barray;
    private final TextExporter texporter_w31j;
    private final TextExporter texporter_u16le;
    private final ByteArrayOutputStream xos;

    public BinaryExporter(OutputStream ostream) throws NullPointerException {
        if (ostream == null) {
            throw new NullPointerException();
        }
        this.ostream = ostream;
        this.barray = new byte[8];
        this.texporter_w31j = new TextExporter(CS_WIN31J);
        this.texporter_u16le = new TextExporter(CS_UTF16LE);
        this.xos = new ByteArrayOutputStream();
    }

    @Override
    public void close() throws IOException {
        this.ostream.close();
    }

    @Override
    public void flush() throws IOException {
        this.ostream.flush();
    }

    public BinaryExporter dumpByte(byte bVal) throws IOException {
        this.ostream.write(bVal);
        return this;
    }

    public BinaryExporter dumpByte(int iVal) throws IOException {
        this.ostream.write(iVal);
        return this;
    }

    public BinaryExporter dumpByteArray(byte[] array) throws IOException {
        this.ostream.write(array);
        return this;
    }

    public BinaryExporter dumpByteArray(byte[] array, int offset, int length) throws IOException {
        this.ostream.write(array, offset, length);
        return this;
    }

    public BinaryExporter dumpLeShort(short sVal) throws IOException {
        this.barray[0] = (byte)(sVal >>> 0);
        this.barray[1] = (byte)(sVal >>> 8);
        this.ostream.write(this.barray, 0, 2);
        return this;
    }

    public BinaryExporter dumpLeShort(int iVal) throws IOException {
        short sVal = (short)iVal;
        this.dumpLeShort(sVal);
        return this;
    }

    public BinaryExporter dumpLeInt(int iVal) throws IOException {
        this.barray[0] = (byte)(iVal >>> 0);
        this.barray[1] = (byte)(iVal >>> 8);
        this.barray[2] = (byte)(iVal >>> 16);
        this.barray[3] = (byte)(iVal >>> 24);
        this.ostream.write(this.barray, 0, 4);
        return this;
    }

    public BinaryExporter dumpLeLong(long lVal) throws IOException {
        this.barray[0] = (byte)(lVal >>> 0);
        this.barray[1] = (byte)(lVal >>> 8);
        this.barray[2] = (byte)(lVal >>> 16);
        this.barray[3] = (byte)(lVal >>> 24);
        this.barray[4] = (byte)(lVal >>> 32);
        this.barray[5] = (byte)(lVal >>> 40);
        this.barray[6] = (byte)(lVal >>> 48);
        this.barray[7] = (byte)(lVal >>> 56);
        this.ostream.write(this.barray, 0, 8);
        return this;
    }

    public BinaryExporter dumpLeFloat(float fVal) throws IOException {
        int rawiVal = Float.floatToRawIntBits(fVal);
        this.dumpLeInt(rawiVal);
        return this;
    }

    public BinaryExporter dumpLeDouble(double dVal) throws IOException {
        long rawlVal = Double.doubleToRawLongBits(dVal);
        this.dumpLeLong(rawlVal);
        return this;
    }

    public BinaryExporter dumpFiller(byte[] filler, int fillerLength) throws IOException {
        if (filler.length <= 0 || fillerLength <= 0) {
            return this;
        }
        byte lastData = filler[filler.length - 1];
        int fillerIdx = 0;
        for (int remain = fillerLength; remain > 0; --remain) {
            byte bVal = fillerIdx < filler.length ? filler[fillerIdx++] : lastData;
            this.dumpByte(bVal);
        }
        return this;
    }

    public BinaryExporter dumpFixedW31j(CharSequence text, int fixedLength, byte[] filler) throws IOException, IllegalTextExportException {
        int encodedSize;
        this.xos.reset();
        try {
            encodedSize = this.texporter_w31j.encodeToByteStream(text, this.xos);
        }
        catch (CharacterCodingException e) {
            throw new IllegalTextExportException(ERRMSG_ILLENC, e);
        }
        if (0 < fixedLength && fixedLength < encodedSize) {
            String message = MessageFormat.format(ERRMSG_TOOLONGTX, text, encodedSize, fixedLength);
            throw new IllegalTextExportException(message);
        }
        this.xos.writeTo(this.ostream);
        int xferred = this.xos.size();
        int remain = fixedLength - xferred;
        if (remain > 0) {
            this.dumpFiller(filler, remain);
        }
        return this;
    }

    public int dumpHollerithUtf16LE(CharSequence text) throws IOException, IllegalTextExportException {
        int encodedSize;
        this.xos.reset();
        try {
            encodedSize = this.texporter_u16le.encodeToByteStream(text, this.xos);
        }
        catch (CharacterCodingException e) {
            assert (false);
            throw new IllegalTextExportException(ERRMSG_ILLENC, e);
        }
        this.dumpLeInt(encodedSize);
        this.xos.writeTo(this.ostream);
        int xferred = this.xos.size();
        assert (xferred == encodedSize);
        return xferred;
    }
}

