/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmd.midiMotion.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import jp.sfjp.mikutoga.bin.parser.MmdFormatException;
import jp.sourceforge.mmd.midiMotion.DrumsMotionBuilder;
import jp.sourceforge.mmd.midiMotion.ProgressLisner;
import jp.sourceforge.mmd.midiMotion.gui.MotionPane;
import jp.sourceforge.mmd.midiMotion.midi.MidiResolver;
import jp.sourceforge.mmd.motion.Motion;
import jp.sourceforge.mmd.motion.swing.FileDropEvent;
import jp.sourceforge.mmd.motion.swing.FileDropListener;
import jp.sourceforge.mmd.motion.swing.FileDropTarget;
import jp.sourceforge.mmd.motion.swing.MmdDialog;

public class DrumMotionPane
extends MotionPane
implements ProgressLisner,
FileDropListener {
    private static final String propertyHead = "midiMotion.drum.";
    protected DrumsMotionBuilder dmb = new DrumsMotionBuilder();
    protected Motion drumMotion;
    protected Motion playerMotion;
    protected File convertTable;
    private JButton buttonConvert;
    private JButton buttonDrum;
    private JButton buttonPlayer;
    private JButton buttonProgress;
    private JProgressBar progressBar;
    private JTextField textConvert;
    private JTextField textDrum;
    private JTextField textPlayer;

    public DrumMotionPane() {
        super("drum");
        FileInputStream fis;
        String s = System.getProperty("midiMotion.drum.drumTemplate");
        this.drumMotion = null;
        if (s != null) {
            this.drumMotion = new Motion();
            try {
                fis = new FileInputStream(s);
                this.drumMotion.fromVMD(fis);
                fis.close();
            }
            catch (IOException ex) {
                this.log("IO\u30a8\u30e9\u30fc", "drum\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u8aad\u307f\u8fbc\u307f\u3002\nFile:" + s + "\n" + ex);
            }
            catch (MmdFormatException ex) {
                this.log("MMD\u30e2\u30fc\u30b7\u30e7\u30f3\u3058\u3083\u3042\u308a\u307e\u305b\u3093", "drum\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u8aad\u307f\u8fbc\u307f\u3002\nFile:" + s + "\n" + ex);
            }
        }
        this.playerMotion = null;
        s = System.getProperty("midiMotion.drum.playerTemplate");
        if (s != null) {
            this.playerMotion = new Motion();
            try {
                fis = new FileInputStream(s);
                this.playerMotion.fromVMD(fis);
                fis.close();
            }
            catch (IOException ex) {
                this.log("IO\u30a8\u30e9\u30fc", "drum\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u8aad\u307f\u8fbc\u307f\u3002\nFile:" + s + "\n" + ex);
            }
            catch (MmdFormatException ex) {
                this.log("MMD\u30e2\u30fc\u30b7\u30e7\u30f3\u3058\u3083\u3042\u308a\u307e\u305b\u3093", "drum\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u8aad\u307f\u8fbc\u307f\u3002\nFile:" + s + "\n" + ex);
            }
        }
        this.convertTable = null;
        s = System.getProperty("midiMotion.drum.convertTable");
        if (s != null) {
            this.convertTable = new File(s);
            if (!this.convertTable.exists()) {
                this.log("\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u306a\u3044", "drum convet table\u8aad\u307f\u8fbc\u307f\u3002\nFile:" + s);
                this.convertTable = null;
            }
        }
        this.initComponents();
        this.textDrum.setDropTarget(new FileDropTarget(this));
        this.textPlayer.setDropTarget(new FileDropTarget(this));
        this.textConvert.setDropTarget(new FileDropTarget(this));
    }

    @Override
    public void setMidiResolver(MidiResolver midiR) {
        super.setMidiResolver(midiR);
        this.buttonProgress.setEnabled(true);
    }

    @Override
    void setFPS(float fps) {
        this.dmb.setFPS(fps);
    }

    @Override
    public void progressStart(int end) {
        this.progressBar.setEnabled(true);
        this.progressBar.setMaximum(end);
        this.progressBar.setValue(0);
    }

    @Override
    public void progressMid(int s) {
        this.progressBar.setValue(s);
        this.progressBar.setString(String.valueOf(s));
    }

    @Override
    public void progressEnd() {
        this.progressBar.setEnabled(false);
        this.progressBar.setMaximum(0);
        this.buttonProgress.setEnabled(true);
        Motion drum = this.dmb.getMotion();
        Motion player = this.dmb.getMotionPlayer();
        String s = System.getProperty("midiMotion.outputDir");
        if (s == null) {
            s = ".";
        }
        JFileChooser jfc = new JFileChooser(s);
        jfc.setFileSelectionMode(1);
        jfc.setToolTipText("\u30d5\u30a9\u30eb\u30c0\u30fc\u3092\u9078\u3076");
        if (jfc.showSaveDialog(this) != 0) {
            return;
        }
        File dir = jfc.getSelectedFile();
        try {
            FileOutputStream fos = new FileOutputStream(new File(dir, "drums.vmd"));
            drum.toVMD(fos);
            fos.close();
            if (player != null) {
                fos = new FileOutputStream(new File(dir, "drumPlayer.vmd"));
                player.toVMD(fos);
                fos.close();
            }
            System.setProperty("midiMotion.outputDir", dir.getParent());
        }
        catch (FileNotFoundException ex) {
            this.log("\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\n", ex.getLocalizedMessage());
        }
        catch (IOException ex) {
            this.log("IO\u30a8\u30e9\u30fc", ex.getLocalizedMessage());
        }
        this.dmb.resetMotion();
    }

    private void initComponents() {
        JLabel jLabel1 = new JLabel();
        JLabel jLabel2 = new JLabel();
        this.textDrum = new JTextField();
        this.textPlayer = new JTextField();
        this.buttonDrum = new JButton();
        this.buttonPlayer = new JButton();
        JLabel jLabel3 = new JLabel();
        this.textConvert = new JTextField();
        this.buttonConvert = new JButton();
        this.buttonProgress = new JButton();
        this.progressBar = new JProgressBar();
        this.setLayout(new GridBagLayout());
        jLabel1.setText("drums \u30e2\u30fc\u30b7\u30e7\u30f3\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8");
        this.add((Component)jLabel1, new GridBagConstraints());
        jLabel2.setText("player \u30e2\u30fc\u30b7\u30e7\u30f3\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.add((Component)jLabel2, gridBagConstraints);
        this.textDrum.setEditable(false);
        this.textDrum.setText(this.drumMotion == null ? "\u307e\u3060" : this.drumMotion.getModelName());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        this.add((Component)this.textDrum, gridBagConstraints);
        this.textPlayer.setEditable(false);
        this.textPlayer.setText(this.playerMotion == null ? "\u307e\u3060" : this.playerMotion.getModelName());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        this.add((Component)this.textPlayer, gridBagConstraints);
        this.buttonDrum.setText("open");
        this.buttonDrum.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DrumMotionPane.this.buttonDrumActionPerformed(evt);
            }
        });
        this.add((Component)this.buttonDrum, new GridBagConstraints());
        this.buttonPlayer.setText("open");
        this.buttonPlayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DrumMotionPane.this.buttonPlayerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.buttonPlayer, gridBagConstraints);
        jLabel3.setText("\u63db\u7b97\u8868");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.add((Component)jLabel3, gridBagConstraints);
        this.textConvert.setEditable(false);
        this.textConvert.setText(this.convertTable == null ? "\u307e\u3060" : this.convertTable.getName());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        this.add((Component)this.textConvert, gridBagConstraints);
        this.buttonConvert.setText("open");
        this.buttonConvert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DrumMotionPane.this.buttonConvertActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        this.add((Component)this.buttonConvert, gridBagConstraints);
        this.buttonProgress.setText("do");
        this.buttonProgress.setEnabled(false);
        this.buttonProgress.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DrumMotionPane.this.buttonProgressActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.add((Component)this.buttonProgress, gridBagConstraints);
        this.progressBar.setString("0");
        this.progressBar.setStringPainted(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        this.add((Component)this.progressBar, gridBagConstraints);
    }

    private void buttonProgressActionPerformed(ActionEvent evt) {
        this.dmb.setTemplate(this.drumMotion, this.playerMotion);
        try {
            FileInputStream fis = new FileInputStream(this.convertTable);
            this.dmb.loadFrameMap(fis);
            fis.close();
        }
        catch (FileNotFoundException ex) {
            this.log("\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", "convert Table:" + this.convertTable.getAbsolutePath());
        }
        catch (IOException ex) {
            this.log("IO\u30a8\u30e9\u30fc", "convert Table \u8aad\u307f\u8fbc\u307f\u4e0d\u826f");
        }
        this.dmb.addProgressListener(this);
        this.buttonProgress.setEnabled(false);
        new Thread(new Runnable(){
            private ProgressLisner perent;

            public Runnable setP(ProgressLisner l) {
                this.perent = l;
                return this;
            }

            @Override
            public void run() {
                DrumMotionPane.this.dmb.setMidiResolver(DrumMotionPane.this.midiR);
                DrumMotionPane.this.dmb.loadMessages();
                DrumMotionPane.this.dmb.removeProgressListener(this.perent);
            }
        }.setP(this)).start();
    }

    private void buttonPlayerActionPerformed(ActionEvent evt) {
        Motion m = MmdDialog.loadMotion(this);
        if (m == null) {
            return;
        }
        this.openPlayerMotion(m);
        System.setProperty("midiMotion.drum.playerTemplate", MmdDialog.lastSelected.getAbsolutePath());
    }

    private void openPlayerMotion(Motion m) {
        this.playerMotion = m;
        this.textPlayer.setText(this.playerMotion.getModelName());
    }

    private void buttonConvertActionPerformed(ActionEvent evt) {
        String s = System.getProperty("midiMotion.drum.drumTemplate");
        JFileChooser jfc = s == null ? new JFileChooser(new File(".")) : new JFileChooser(new File(s).getParentFile());
        jfc.setFileFilter(new FileNameExtensionFilter("CSV convert table", "csv"));
        if (jfc.showOpenDialog(this) != 0) {
            return;
        }
        this.openConvertTable(jfc.getSelectedFile());
    }

    private void openConvertTable(File f) {
        this.convertTable = f;
        this.textConvert.setText(this.convertTable.getName());
        System.setProperty("midiMotion.drum.convertTable", this.convertTable.getAbsolutePath());
    }

    private void buttonDrumActionPerformed(ActionEvent evt) {
        Motion m = MmdDialog.loadMotion(this);
        if (m == null) {
            return;
        }
        this.openDrumMotion(m);
        System.setProperty("midiMotion.drum.drumTemplate", MmdDialog.lastSelected.getAbsolutePath());
    }

    private void openDrumMotion(Motion m) {
        this.drumMotion = m;
        this.textDrum.setText(this.drumMotion.getModelName());
    }

    @Override
    public void fileDrop(FileDropEvent e) {
        Object src = e.getSource();
        File file = e.getFiles()[0];
        String name = file.getName().toLowerCase();
        if (src == this.textDrum || src == this.textPlayer) {
            Motion m = null;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                if (name.endsWith(".vmd")) {
                    m = new Motion().fromVMD(fis);
                } else if (name.endsWith(".csv")) {
                    m = new Motion().fromVMD(fis);
                }
                fis.close();
            }
            catch (FileNotFoundException ex) {
                JOptionPane.showMessageDialog(this, "\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093: " + ex.getLocalizedMessage());
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "\u30d5\u30a1\u30a4\u30eb\u304c\u8aad\u307f\u53d6\u308c\u307e\u305b\u3093: " + ex.getLocalizedMessage());
            }
            catch (MmdFormatException ex) {
                JOptionPane.showMessageDialog(this, "MMD\u306e\u30e2\u30fc\u30b7\u30e7\u30f3\u30d5\u30a1\u30a4\u30eb\u3067\u306f\u3042\u308a\u307e\u305b\u3093: " + ex.getLocalizedMessage());
                try {
                    fis.close();
                }
                catch (IOException ex2) {
                    JOptionPane.showMessageDialog(this, "\u30d5\u30a1\u30a4\u30eb\u304c\u8aad\u307f\u53d6\u308c\u307e\u305b\u3093: " + ex2.getLocalizedMessage());
                }
            }
            if (m == null) {
                return;
            }
            if (src == this.textDrum) {
                this.openDrumMotion(m);
                System.setProperty("midiMotion.drum.drumTemplate", file.getPath());
            } else {
                this.openPlayerMotion(m);
                System.setProperty("midiMotion.drum.playerTemplate", file.getPath());
            }
        } else {
            if (!name.endsWith(".csv")) {
                return;
            }
            this.openConvertTable(file);
        }
    }
}

