/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.xml;

import java.text.MessageFormat;
import java.util.Iterator;
import javax.xml.bind.DatatypeConverter;
import jp.sfjp.mikutoga.xml.SiblingElemIterator;
import jp.sfjp.mikutoga.xml.TogaXmlException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DomNsUtils {
    private static final String ERRMSG_NOELEM = "Elem:[{0}] was not found in Elem:[{1}]";
    private static final String ERRMSG_NOATTR = "Attr:[{0}] was not found in Elem:[{1}]";
    private static final String ERRMSG_INVATTR = "Invalid attribute form Attr[{0}] Value[{1}]";

    private DomNsUtils() {
        assert (false);
        throw new AssertionError();
    }

    public static boolean hasNsLocalNameNode(Node node, String nsuri, String localName) {
        String nodeLocalName = node.getLocalName();
        String nodeNsUri = node.getNamespaceURI();
        if (localName != null && !localName.equals(nodeLocalName)) {
            return false;
        }
        return nsuri == null || nodeNsUri == null || nsuri.equals(nodeNsUri);
    }

    public static boolean hasNsLocalNameElem(Node node, String nsuri, String localName) {
        if (node.getNodeType() != 1) {
            return false;
        }
        return DomNsUtils.hasNsLocalNameNode(node, nsuri, localName);
    }

    public static boolean hasChild(Element parent, String nsuri, String localName) {
        for (Node node = parent.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!DomNsUtils.hasNsLocalNameElem(node, nsuri, localName)) continue;
            return true;
        }
        return false;
    }

    public static Element pickFirstChild(Node parent, String nsuri, String localName) {
        Node node;
        for (node = parent.getFirstChild(); node != null && !DomNsUtils.hasNsLocalNameElem(node, nsuri, localName); node = node.getNextSibling()) {
        }
        return (Element)node;
    }

    public static Element getFirstChild(Element parent, String nsuri, String localName) throws TogaXmlException {
        Element elem = DomNsUtils.pickFirstChild(parent, nsuri, localName);
        if (elem == null) {
            String message = MessageFormat.format(ERRMSG_NOELEM, localName, parent.getLocalName());
            throw new TogaXmlException(message);
        }
        return elem;
    }

    public static Iterable<Element> getEachChild(final Element parent, final String nsuri, final String localName) {
        Iterable<Element> result = new Iterable<Element>(){

            @Override
            public Iterator<Element> iterator() {
                return new SiblingElemIterator(parent, nsuri, localName);
            }
        };
        return result;
    }

    public static boolean hasAttrNS(Element elem, String nsuri, String localName) {
        return elem.hasAttributeNS(nsuri, localName);
    }

    public static String getStringAttrNS(Element elem, String nsuri, String localName) throws TogaXmlException {
        String result;
        if (!DomNsUtils.hasAttrNS(elem, nsuri, localName)) {
            String message = MessageFormat.format(ERRMSG_NOATTR, localName, elem.getLocalName());
            throw new TogaXmlException(message);
        }
        try {
            result = elem.getAttributeNS(nsuri, localName);
        }
        catch (DOMException e) {
            assert (false);
            throw new AssertionError((Object)e);
        }
        return result;
    }

    public static boolean getBooleanAttrNS(Element elem, String nsuri, String localName) throws TogaXmlException {
        boolean result;
        String value = DomNsUtils.getStringAttrNS(elem, nsuri, localName);
        try {
            result = DatatypeConverter.parseBoolean((String)value);
        }
        catch (IllegalArgumentException e) {
            String message = MessageFormat.format(ERRMSG_INVATTR, localName, value);
            throw new TogaXmlException(message, e);
        }
        return result;
    }

    public static int getIntegerAttrNS(Element elem, String nsuri, String localName) throws TogaXmlException {
        int result;
        String value = DomNsUtils.getStringAttrNS(elem, nsuri, localName);
        try {
            result = DatatypeConverter.parseInt((String)value);
        }
        catch (NumberFormatException e) {
            String message = MessageFormat.format(ERRMSG_INVATTR, localName, value);
            throw new TogaXmlException(message, e);
        }
        return result;
    }

    public static float getFloatAttrNS(Element elem, String nsuri, String localName) throws TogaXmlException {
        float result;
        String value = DomNsUtils.getStringAttrNS(elem, nsuri, localName);
        try {
            result = DatatypeConverter.parseFloat((String)value);
        }
        catch (NumberFormatException e) {
            String message = MessageFormat.format(ERRMSG_INVATTR, localName, value);
            throw new TogaXmlException(message, e);
        }
        return result;
    }
}

