/*
 * The MIT License
 *
 * Copyright 2015 nazo.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package jp.sourceforge.mmd.motion;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;

/**
 * package limited なクラス.
 * フレームごとのポーズの管理.
 * @author nazo
 */
@SuppressWarnings("FieldMayBeFinal")
class MoveOnFrame implements Comparable {
    private int frame;
    protected TreeMap<String,Pose> poses;
    protected TreeMap<String,MorphPose> morphPoses;
    protected ArrayList<BooleanPose> booleanPoses;

    public MoveOnFrame(int frame){
        this.frame=frame;
        poses=new TreeMap<String,Pose>();
        morphPoses=new TreeMap<String,MorphPose>();
        booleanPoses=new ArrayList<BooleanPose>();
    }

    @Override
    public int hashCode(){
        return frame;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final MoveOnFrame other = (MoveOnFrame) obj;
        return this.frame == other.frame;
    }


    public void put(Pose p){
        if(p instanceof BooleanPose){
            booleanPoses.add((BooleanPose)p);
        } else if(p instanceof MorphPose){
            morphPoses.put(p.nameOfBone,(MorphPose)p);
        } else {
            poses.put(p.nameOfBone, p);            
        }
    }
    public Pose get(String s){
        return poses.get(s);
    }
    public void remove(String s){
        poses.remove(s);
    }
    public int size(){
        return poses.size()+booleanPoses.size();
    }
    public Pose [] toArray(){
        Pose [] ps=new Pose[poses.size()+morphPoses.size()+booleanPoses.size()];
        Iterator<? extends Pose> ip=morphPoses.values().iterator();
        Pose p;
        int i=0;

        while(ip.hasNext()){
            p=ip.next();
            ps[i]=p.clone();
            i++;
        }

        ip=poses.values().iterator();
        while(ip.hasNext()){
            p=ip.next();
            ps[i]=p.clone();
            i++;
        }

        ip=booleanPoses.iterator();
        while(ip.hasNext()){
            p=ip.next();
            ps[i]=p.clone();
            i++;
        }
        return ps;
    }
    
    @Override
    public int compareTo(Object o) {
        if(o==null)
            return 1;
        if(o.getClass()!=getClass())
            return 1;
        MoveOnFrame other=(MoveOnFrame)o;
        return frame-other.frame;
    }
    
}
